ORCA/M Asm65816 2.1.0

0001 D000              *********************************************************************************
0002 D000              *                                                                               *
0003 D000              *                               GQuit - E0 segment                              *
0004 D000              *                                                                               *
0005 D000              *                       Copyright Apple Computer, Inc. 1986-1993                *
0006 D000              *                                                                               *
0007 D000              *                               All Rights Reserved                             *
0008 D000              *                                                                               *
0009 D000              *********************************************************************************
0010 D000
0011 D000
0012 D000              *********************************************************************************
0013 D000                       SEG   'seg_e0'
0014 D000              org_dummy_5 proc org e0_obj_pstn
0015 D000                       endp 
0016 D000              *********************************************************************************
0017 D000
0018 D000
0019 D000
0020 D000              ;==============================================================================
0021 D000              ; ProDOS 8 QUIT
0022 D000              ;
0023 D000              ; Entry is in 8-bit native mode.
0024 D000              ; Exit is in 16-bit native mode.
0025 D000              ;
0026 D000              ; Data bank register is set to bank $00 on entry.
0027 D000              ; Direct register is set to $000000 on entry.
0028 D000              ; Stack pointer is set to $01xx on entry.
0029 D000              ;
0030 D000              ; Data bank register is set to bank $E1 on exit.
0031 D000              ; Direct register is set to $000000 on exit.
0032 D000              ; Stack pointer is set to $01xx on exit.
0033 D000              ;
0034 D000              ; This is the entry point for QUIT calls originating from ProDOS 8.
0035 D000              ;==============================================================================
0036 D000
0037 D000              p8quit   PROC 
0038 D000                       DataChk off
0039 D000
0040 D000                       longa off
0041 D000                       longi off
0042 D000
0043 D000              ; First, let's ensure a known machine state.
0044 D000              ; Shadow I/O space, language cards and text page 1 only.
0045 D000              ; Preserve state of text page 2 shadowing.
0046 D000              ; Set normal zero page and stack, page 1, read main memory, write main memory,
0047 D000              ; read ROM off, language card 1st bank.
0048 D000              ; Turn off 80STORE.
0049 D000              ; Setup system to match battery ram parameters except for slot stuff.
0050 D000
0051 D000 AF 35 C0 00           lda   >shadow
0052 D004 29 20                 and   #text_page_2_bit
0053 D006 09 1E                 ora   #p16_shadowmask
0054 D008 8F 35 C0 00           sta   >shadow
0055 D00C 9C 68 C0              stz   |statereg
0056 D00F 9C 00 C0              stz   |clr80col
0057 D012 38                    sec   
0058 D013 22 94 00 E1           jsl   tobramsetup
0059 D017
0060 D017              ; Now begin 16-bit mode
0061 D017
0062 D017 C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
0063 D019                       longa on
0064 D019                       longi on
0065 D019
0066 D019              ; Increment the system busy flag
0067 D019
0068 D019 22 64 00 E1           jsl   >incbusyflg
0069 D01D
0070 D01D              ; Set the data bank register to bank $E1
0071 D01D
0072 D01D F4 E1 E1              pea   $e1e1
0073 D020 AB                    plb   
0074 D021 AB                    plb   
0075 D022
0076 D022              ; Identify the current operating system as ProDOS 8
0077 D022
0078 D022 A9 00 80              lda   #$8000
0079 D025 8D 81 D6              sta   |e1_current_os
0080 D028
0081 D028              ; Set initial values of variables to zero where needed
0082 D028
0083 D028 20 E8 D2              jsr   initialize_data
0084 D02B
0085 D02B              ; Initialize prefix flag to say that QUIT call specified a full pathname
0086 D02B
0087 D02B A9 FF FF              lda   #$ffff
0088 D02E 8D 7D D6              sta   |e1_quit_prefix
0089 D031
0090 D031              ; Now let's set the data bank register to bank $00
0091 D031
0092 D031 F4 00 00              pea   $0000
0093 D034 AB                    plb   
0094 D035 AB                    plb   
0095 D036
0096 D036              ; Now check the quit type
0097 D036
0098 D036 A0 01 00              ldy   #1
0099 D039 B1 40                 lda   (<PAR),y
0100 D03B 29 FF 00              and   #$00ff
0101 D03E C9 EE 00              cmp   #$00ee
0102 D041 D0 47                 bne   no_path                  ;it's not $EE, so there's no pathname
0103 D043
0104 D043              ; It's an extended quit call, so copy the pathname into e1_p8quit_path
0105 D043
0106 D043 0B                    phd                            ; save direct register
0107 D044
0108 D044 A0 02 00              ldy   #2                       ; Get the pointer to the user's
0109 D047 B1 40                 lda   (<PAR),y                 ; pathname from his parameter list.
0110 D049 5B                    tcd                            ; and store in direct register
0111 D04A
0112 D04A A5 00                 lda   <0                       ; Get first word of user's pathname.
0113 D04C AA                    tax                            ; save for later
0114 D04D
0115 D04D 29 FF 00              and   #$00ff                   ; mask off hi byte
0116 D050 C9 41 00              cmp   #p8_max_length+1         ; check length byte - is it too long?
0117 D053 90 06                 bcc   len_ok                   ; no
0118 D055 A9 40 00     syntax_error lda   #bad_path_syntax     ; yes - so report a syntax error
0119 D058 4C D2 DF              jmp   p8_fatal_err2            ; fatal error - no return
0120 D05B              len_ok    
0121 D05B
0122 D05B 8A                    txa                            ; get back first word of pathname
0123 D05C EB                    xba                            ; get first character into low byte
0124 D05D 29 FF 00              and   #$00ff                   ; mask off length byte
0125 D060 C9 2F 00              cmp   #'/'                     ; does pathname begin with a slash?
0126 D063 F0 07                 beq   full_path                ; yes - so it's a full pathname
0127 D065 A9 00 00              lda   #0
0128 D068 8F 7D D6 E1           sta   >e1_quit_prefix          ; indicate that pathname was partial
0129 D06C              full_path  
0130 D06C
0131 D06C E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0132 D06E                       longa off
0133 D06E                       longi off
0134 D06E
0135 D06E A6 00                 ldx   <0                       ; Get length of pathname in X
0136 D070              path_loop  
0137 D070 B5 00                 lda   <0,x                     ; Copy user pathname to e1_p8quit_path
0138 D072 9F E5 D7 E1           sta   >e1_p8quit_path,x
0139 D076 CA                    dex   
0140 D077 10 F7                 bpl   path_loop
0141 D079
0142 D079 C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
0143 D07B                       longa on
0144 D07B                       longi on
0145 D07B
0146 D07B 2B                    pld                            ;retore direct register
0147 D07C
0148 D07C A9 E5 D7              lda   #e1_p8quit_path          ;set up pointer to pathname
0149 D07F 8F 6F D6 E1           sta   >e1_path_ptr
0150 D083 A9 E1 00              lda   #e1_p8quit_path>>16
0151 D086 8F 71 D6 E1           sta   >e1_path_ptr+2
0152 D08A
0153 D08A              no_path   
0154 D08A
0155 D08A              ; Now begin 8-bit mode
0156 D08A
0157 D08A E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0158 D08C                       longa off
0159 D08C                       longi off
0160 D08C
0161 D08C              ; Since we're not going back to ProDOS 8, clear the active flag
0162 D08C              ; (This must be done after we have used <PAR but before our first OS call)
0163 D08C
0164 D08C 9C 9B BF              stz   |mliactive               ; Zero the MLIACTV flag
0165 D08F
0166 D08F              ; Clear the ProDOS 8 bit map
0167 D08F
0168 D08F A2 18                 ldx   #24
0169 D091 A9 00                 lda   #0
0170 D093 9D 58 BF     loop1    sta   |$BF58,X
0171 D096 CA                    dex   
0172 D097 D0 FA                 bne   loop1
0173 D099 1A                    inc   a
0174 D09A 8D 6F BF              sta   |$BF6F                   ; Mark ProDOS 8 global page in use
0175 D09D A9 CF                 lda   #$CF
0176 D09F 8D 58 BF              sta   |$BF58                   ; and pages 0,1,4,5,6,7
0177 D0A2
0178 D0A2              ; Set the level to zero
0179 D0A2
0180 D0A2 8A                    txa   
0181 D0A3 8D 94 BF              sta   |$BF94                   ; Zero the level
0182 D0A6
0183 D0A6              ; Drop some code into bank $00 for making a P8 Close call
0184 D0A6              ; (No need to preserve anything.  We ain't goin back, no mo.)
0185 D0A6
0186 D0A6 A2 0E                 ldx   #close_end-close_start-1 ;# of bytes to move - 1
0187 D0A8 BF 3C D1 E0  loop2    lda   >close_start,x
0188 D0AC 9D 00 02              sta   |$200,x                  ; store the code at $000200
0189 D0AF CA                    dex   
0190 D0B0 10 F6                 bpl   loop2
0191 D0B2
0192 D0B2 22 00 02 00           jsl   >$000200                 ; make the call - don't worry about errors
0193 D0B6
0194 D0B6              ; Now get P8's prefix for later use
0195 D0B6              ; Drop some code into bank $00 for making a P8 GetPrefix call
0196 D0B6
0197 D0B6 A2 0F                 ldx   #pfx_end-pfx_start-1     ;# of bytes to move - 1.
0198 D0B8 BF 2C D1 E0  loop3    lda   >pfx_start,x
0199 D0BC 9D 00 02              sta   |$200,x                  ; store the code at $000200
0200 D0BF CA                    dex   
0201 D0C0 10 F6                 bpl   loop3
0202 D0C2
0203 D0C2 22 00 02 00           jsl   >$000200                 ; make the call
0204 D0C6 C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
0205 D0C8 D0 57                 bne   local_fatal              ; fatal error - no return
0206 D0CA E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0207 D0CC
0208 D0CC              ; Copy ProDOS 8's prefix into GQuit's data area
0209 D0CC
0210 D0CC AE 80 02              ldx   |$280                    ; Get length byte of the prefix
0211 D0CF BD 80 02     copy_pfx lda   |$280,x                  ; Copy the prefix
0212 D0D2 9F 2A D8 E1           sta   >e1_prefix_buf,x
0213 D0D6 CA                    dex   
0214 D0D7 10 F6                 bpl   copy_pfx
0215 D0D9
0216 D0D9              ; Now begin 16-bit mode
0217 D0D9
0218 D0D9 C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
0219 D0DB                       longa on
0220 D0DB                       longi on
0221 D0DB
0222 D0DB              ; Now let's set the data bank register to bank $E1
0223 D0DB
0224 D0DB F4 E1 E1              pea   $e1e1
0225 D0DE AB                    plb   
0226 D0DF AB                    plb   
0227 D0E0
0228 D0E0              ; Check to see if the Quit call specified a pathname to link to
0229 D0E0
0230 D0E0 AD E5 D7              lda   |e1_p8quit_path
0231 D0E3 29 FF 00              and   #$00ff
0232 D0E6 F0 3C                 beq   no_path2
0233 D0E8
0234 D0E8              ; The Quit call specified a pathname...
0235 D0E8
0236 D0E8 AD 7D D6              lda   |e1_quit_prefix          ;did Quit call specify full pathname?
0237 D0EB 30 2B                 bmi   full_path2               ;yes
0238 D0ED
0239 D0ED 18                    clc   
0240 D0EE AD 2A D8              lda   |e1_prefix_buf           ;check length of prefix+pathname
0241 D0F1 6D E5 D7              adc   |e1_p8quit_path
0242 D0F4 29 FF 00              and   #$00ff
0243 D0F7 C9 41 00              cmp   #p8_max_length+1         ;is it too long?
0244 D0FA 90 03                 bcc   len_ok2                  ;no
0245 D0FC 4C 55 D0              jmp   syntax_error             ;yes - so report a syntax error
0246 D0FF              len_ok2   
0247 D0FF
0248 D0FF F4 00 00              pea   0                        ;indicate class 0 strings
0249 D102 F4 E1 00              pea   e1_prefix_buf>>16        ;push address of string 1 to concat
0250 D105 F4 2A D8              pea   e1_prefix_buf
0251 D108 F4 E1 00              pea   e1_p8quit_path>>16       ;push address of string 2 to concat
0252 D10B F4 E5 D7              pea   e1_p8quit_path
0253 D10E F4 E1 00              pea   e1_p8quit_path>>16       ;push address of resultant string
0254 D111 F4 E5 D7              pea   e1_p8quit_path
0255 D114 22 AB D2 E1           jsl   concat                   ;concat the strings
0256 D118
0257 D118              full_path2  
0258 D118 18                    clc                            ;indicate class 0 string
0259 D119 20 0A D3              jsr   copy_volname             ;copy volname for mount_volume window
0260 D11C
0261 D11C 20 98 DC              jsr   get_info_sub             ;get info about the application
0262 D11F 90 08                 bcc   got_next_prog
0263 D121 4C CF DF     local_fatal jmp   p8_fatal_err          ;fatal error - no return
0264 D124
0265 D124
0266 D124              ; The Quit call did not specify a pathname...
0267 D124              ; Decide on next program to execute
0268 D124
0269 D124              no_path2  
0270 D124 20 40 D3              jsr   get_next_prog
0271 D127 B0 F8                 bcs   local_fatal              ;fatal error - no return
0272 D129
0273 D129
0274 D129              ; We now have a program to execute so launch it
0275 D129
0276 D129              got_next_prog  
0277 D129 4C 9D D3              jmp   launch_app
0278 D12C
0279 D12C
0280 D12C              ;-------------------------------------------------------------------------------
0281 D12C              ; Get Prefix code
0282 D12C              ;
0283 D12C              ; Entry is in 8-bit native mode.
0284 D12C              ; Exit is in 8-bit native mode.
0285 D12C              ; Data bank register is set to bank $00 on entry and exit.
0286 D12C              ;
0287 D12C              ; Inputs:       none
0288 D12C              ;
0289 D12C              ; Outputs:      z - 1 if no error ; 0 if error
0290 D12C              ;               A - error code if z=0
0291 D12C              ;
0292 D12C              ; Notes:        This code is moved to $00/0200 and executed there.
0293 D12C              ;
0294 D12C              ; This is the Bank $00 code used to make the P8 Get Prefix call.
0295 D12C              ;-------------------------------------------------------------------------------
0296 D12C
0297 D12C              pfx_start  
0298 D12C 38                    DC B:$38                       ;sec
0299 D12D FB                    DC B:$FB                       ;xce - go to emulation mode
0300 D12E 20                    DC B:$20                       ;jsr ProDOS8 - Call ProDOS 8
0301 D12F 00 BF                 DC W:ProDos8
0302 D131 C7                    DC B:$c7                       ;Get Prefix command number
0303 D132 0D 02                 DC W:pfx_parms-pfx_start+$200  ;Address of parameter list
0304 D134 29                    DC B:$29                       ;and #$ff
0305 D135 FF                    DC B:$FF
0306 D136 18                    DC B:$18                       ;clc - Go back to native mode
0307 D137 FB                    DC B:$FB                       ;xce - Note: Must use z flag to check error!
0308 D138 6B                    DC B:$6B                       ;rtl
0309 D139
0310 D139              pfx_parms                               ;parameter list for P8 Get Prefix call
0311 D139 01                    DC B:1                         ;number of parameters is 1
0312 D13A 80 02                 DC W:$280                      ;pointer to prefix buffer
0313 D13C
0314 D13C              pfx_end   
0315 D13C
0316 D13C
0317 D13C              ;-------------------------------------------------------------------------------
0318 D13C              ; Close code
0319 D13C              ;
0320 D13C              ; Entry is in 8-bit native mode.
0321 D13C              ; Exit is in 8-bit native mode.
0322 D13C              ; Data bank register is set to bank $00 on entry and exit.
0323 D13C              ;
0324 D13C              ; Inputs:       none
0325 D13C              ;
0326 D13C              ; Outputs:      none
0327 D13C              ;
0328 D13C              ; Notes:        This code is moved to $00/0200 and executed there.
0329 D13C              ;
0330 D13C              ; This is the Bank $00 code used to make the P8 Close call.
0331 D13C              ;-------------------------------------------------------------------------------
0332 D13C
0333 D13C              close_start  
0334 D13C 38                    DC B:$38                       ;sec
0335 D13D FB                    DC B:$FB                       ;xce - go into emulation mode
0336 D13E 20                    DC B:$20                       ;jsr ProDOS8 - Call ProDOS 8
0337 D13F 00 BF                 DC W:ProDos8
0338 D141 CC                    DC B:$CC                       ;Close command number
0339 D142 0D 02                 DC W:close_parms-close_start+$200 ;address of parm list
0340 D144 08                    DC B:$08                       ;php
0341 D145 18                    DC B:$18                       ;clc
0342 D146 FB                    DC B:$FB                       ;xce - go back to native mode
0343 D147 28                    DC B:$28                       ;plp
0344 D148 6B                    DC B:$6B                       ;rtl
0345 D149
0346 D149              close_parms                             ;parameter list for P8 Close call
0347 D149 01                    DC B:1                         ;number of parameters is 1
0348 D14A 00                    DC B:0                         ;ref num
0349 D14B
0350 D14B              close_end  
0351 D14B                       DataChk on
0352 D14B                       ENDP 
0353 D14B
0354 D14B
0355 D14B
0356 D14B                       eject 
0357 D14B              ;==============================================================================
0358 D14B              ; ProDOS 16 QUIT
0359 D14B              ;
0360 D14B              ; Entry is in 16-bit native mode.
0361 D14B              ; Exit is in 16-bit native mode.
0362 D14B              ;
0363 D14B              ; Data bank register is unknown at entry.
0364 D14B              ; Direct register is set to the GS/OS direct page at $00BD00 on entry.
0365 D14B              ; Stack pointer is set to the application's stack on entry. ??
0366 D14B              ;
0367 D14B              ; Data bank register is set to bank $E1 on exit.
0368 D14B              ; Direct register is set to the GS/OS direct page at $00BD00 on exit.
0369 D14B              ; Stack pointer is set to GQuit's stack on exit.
0370 D14B              ;
0371 D14B              ; Inputs:       Y - call class * 2
0372 D14B              ;               X - prefix #, if quit call specified a partial pathname
0373 D14B              ;                   $FFFF, if quit call did not specify a partial pathname
0374 D14B              ;               <param_blk_ptr - pointer to the Quit call parameter block
0375 D14B              ;               <path_flag - bit 14 is set if a pathname was specified
0376 D14B              ;               <path1_ptr - pointer to the Quit pathname in class 1 format
0377 D14B              ;                            (partial pathnames are expanded by SCM)
0378 D14B              ;               >v_ptr1 - SCM's virtual pointer to the pathname
0379 D14B              ;
0380 D14B              ; This is the entry point for QUIT calls originating from GS/OS.
0381 D14B              ;==============================================================================
0382 D14B
0383 D14B                       EXPORT p16quit
0384 D14B              p16quit  PROC 
0385 D14B                       DataChk off
0386 D14B                       Import gsos_nonfatal2
0387 D14B
0388 D14B                       longa on
0389 D14B                       longi on
0390 D14B
0391 D14B              ; First, let's save the call class and the prefix info for later.
0392 D14B
0393 D14B 98                    tya                            ;Y contains call class * 2
0394 D14C 8F 53 D6 E1           sta   >e1_word_temp
0395 D150 8A                    txa                            ;X contains the prefix # (if quit call
0396 D151 8F 7D D6 E1           sta   >e1_quit_prefix          ;specified a partial pathname)
0397 D155
0398 D155              ; Now, let's ensure a known machine state.
0399 D155              ; Shadow I/O space, language cards and text page 1 only.
0400 D155              ; Preserve state of text page 2 shadowing.
0401 D155              ; Set normal zero page and stack, page 1, read main memory, write main memory,
0402 D155              ; read ROM off, language card 1st bank.
0403 D155              ; Turn off 80STORE.
0404 D155
0405 D155                       longa off
0406 D155                       longi off
0407 D155 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0408 D157
0409 D157 AF 35 C0 00           lda   >shadow
0410 D15B 29 20                 and   #text_page_2_bit
0411 D15D 09 1E                 ora   #p16_shadowmask
0412 D15F 8F 35 C0 00           sta   >shadow
0413 D163 A9 00                 lda   #$00
0414 D165 8F 68 C0 00           sta   >statereg
0415 D169 8F 00 C0 00           sta   >clr80col
0416 D16D
0417 D16D                       longa on
0418 D16D                       longi on
0419 D16D C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0420 D16F
0421 D16F              ; Now, let's set the stack to GQuit's own stack.
0422 D16F              ; But before we do, we must check what the stack is currently set to.
0423 D16F              ; If it's Page 1 we must set $010100 to the value in S.
0424 D16F
0425 D16F 3B                    tsc                            ; get current stack
0426 D170 29 00 FF              and   #$FF00                   ; look at high byte
0427 D173 C9 00 01              cmp   #$0100                   ; is it 1?
0428 D176 D0 09                 bne   set_new_stack            ; no, so never mind
0429 D178 3B                    tsc                            ; get it again
0430 D179 E2 30                 sep   #$30                     ; go into 8 bit mode
0431 D17B 8F 00 01 01           sta   >mnemstkptr              ; store it
0432 D17F C2 30                 rep   #$30                     ; back to 16 bit mode
0433 D181 A9 FF BC     set_new_stack lda   #gquit_stack_top    ; set stack to GQuit's own stack
0434 D184 1B                    tcs   
0435 D185
0436 D185              ; Set the data bank register to bank $E1.
0437 D185
0438 D185 F4 E1 E1              pea   $e1e1
0439 D188 AB                    plb   
0440 D189 AB                    plb   
0441 D18A
0442 D18A              ; Identify the current operating system as GS/OS
0443 D18A
0444 D18A 9C 81 D6              stz   |e1_current_os
0445 D18D
0446 D18D              ; Set initial values of variables to zero where needed
0447 D18D
0448 D18D 20 E8 D2              jsr   initialize_data
0449 D190
0450 D190              ; Tell SCM to automatically put up the 'mount volume' dialog
0451 D190              ; and make sure our error messages are not suppressed
0452 D190
0453 D190 AF F6 B9 00           lda   >sys_prefs               ;get preferences flag
0454 D194 09 00 80              ora   #$8000                   ;set bit 15 - mount volume bit
0455 D197 29 FF DF              and   #$DFFF                   ;clear bit 13 - error messages bit
0456 D19A 8F F6 B9 00           sta   >sys_prefs
0457 D19E
0458 D19E              ; Get the 'flags' word from the Quit parameter block and store for future use.
0459 D19E              ; If the Quit call was a Class 1 call, we have to check the 'parameter count'
0460 D19E              ; first to see if the 'flags' word was specified.
0461 D19E
0462 D19E AC 53 D6              ldy   |e1_word_temp            ;retrieve call class * 2
0463 D1A1 F0 07                 beq   get_flags                ;class 0 so we know there is a flag word
0464 D1A3 A7 32                 lda   [<param_blk_ptr]         ;class 1 so check parameter count
0465 D1A5 C9 02 00              cmp   #2                       ;does parameter block contain flag word?
0466 D1A8 90 09                 bcc   no_params                ;no, so skip next section
0467 D1AA              get_flags  
0468 D1AA
0469 D1AA              ;	tya
0470 D1AA              ;	clc
0471 D1AA              ;	adc	#$0004	;create offset to flags word
0472 D1AA              ;	tay
0473 D1AA              *** optimized 4-Jun-92 DAL to save 2 bytes (now I just need two more)
0474 D1AA C8                    iny   
0475 D1AB C8                    iny   
0476 D1AC C8                    iny   
0477 D1AD C8                    iny   
0478 D1AE              *** end 4-Jun-92
0479 D1AE
0480 D1AE B7 32                 lda   [<param_blk_ptr],y       ;get flags word
0481 D1B0 8D 7F D6              sta   |e1_quit_flags           ;and save
0482 D1B3              no_params  
0483 D1B3
0484 D1B3              ; Is the pathname pointer null or the pathname length zero?
0485 D1B3
0486 D1B3 24 42                 bit   <path_flag               ; bit 14 is set if pathname1 is non-null
0487 D1B5 50 54                 bvc   no_path                  ; pathname pointer is null so no path
0488 D1B7
0489 D1B7 A7 3A                 lda   [<path1_ptr]             ; get length word of pathname1
0490 D1B9 F0 42                 beq   null_path                ; pathname length is 0
0491 D1BB
0492 D1BB              ; The Quit call specified a pathname...
0493 D1BB
0494 D1BB              ; Call the memory manager to allocate space to make a copy of the pathname
0495 D1BB              ; since SCM's copy isn't locked down and will move if memory is compacted.
0496 D1BB
0497 D1BB 20 6C D2              jsr   copy_pathname            ;copy pathname into our own data area
0498 D1BE B0 65                 bcs   local_fatal
0499 D1C0
0500 D1C0              ; Now notify SCM that we're done with its copy of the pathname so it can
0501 D1C0              ; deallocate the data area.
0502 D1C0              ; The direct register must be set to the GS/OS direct page for the call to SCM
0503 D1C0
0504 D1C0 AF C6 B9 00           lda   >v_ptr1                  ;get pathname's virtual ptr from SCM
0505 D1C4 AA                    tax   
0506 D1C5 AF C8 B9 00           lda   >v_ptr1+2
0507 D1C9 A8                    tay   
0508 D1CA 22 15 FD 00           jsl   >deallocate              ;notify SCM to deallocate space
0509 D1CE
0510 D1CE              ; Since we're not going back to GS/OS, clear the active flag
0511 D1CE              ; (we must do this after we have copied the pathname but before our first
0512 D1CE              ;  OS call)
0513 D1CE
0514 D1CE AF BE 00 E1           lda   >os_flag                 ; Clear bit 15 (GS/OS Active Flag)
0515 D1D2 0A                    asl   a
0516 D1D3 4A                    lsr   a
0517 D1D4 8F BE 00 E1           sta   >os_flag
0518 D1D8
0519 D1D8              ; SCM always gives us a full pathname so now copy the volume name from the
0520 D1D8              ; front of the pathname into a separate string which will be used for the
0521 D1D8              ; 'mount volume' window.
0522 D1D8
0523 D1D8 38                    sec                            ;indicate class 1 string
0524 D1D9 20 0A D3              jsr   copy_volname             ;copy volname for mount_volume window
0525 D1DC
0526 D1DC              ; Call the loader and the OS to get information about the application.
0527 D1DC
0528 D1DC 20 98 DC              jsr   get_info_sub             ;get info about application
0529 D1DF 90 47                 bcc   got_next_prog            ;no errors
0530 D1E1 20 9D DF              jsr   gsos_nonfatal2           ;display dialog
0531 D1E4 AD 7F D6              lda   |e1_quit_flags           ;is current app putting it's ID on the stack?
0532 D1E7 10 22                 bpl   no_path                  ;no, so just ignore the supplied pathname
0533 D1E9 0A                    asl   a                        ;clear the PushID bit
0534 D1EA 4A                    lsr   a
0535 D1EB 8D 7F D6              sta   |e1_quit_flags           ;and put back
0536 D1EE AD 79 D6              lda   |e1_Current_id           ;get the ID of the current app
0537 D1F1 8D 7B D6              sta   e1_open_id               ;and store as ID of next program to launch
0538 D1F4 A9 B3 00              lda   #$B3                     ;must be application type
0539 D1F7 8D 83 D6              sta   e1_load_type
0540 D1FA 4C 28 D2              jmp   got_next_prog            ;fake it
0541 D1FD
0542 D1FD
0543 D1FD              ; The Quit call specified a pathname of length 0...
0544 D1FD
0545 D1FD              null_path  
0546 D1FD
0547 D1FD              ; Notify SCM that we're done with its copy of the pathname so it can
0548 D1FD              ; deallocate the data area.
0549 D1FD              ; The direct register must be set to the GS/OS direct page for the call to SCM
0550 D1FD
0551 D1FD AF C6 B9 00           lda   >v_ptr1                  ;get pathname's virtual ptr from SCM
0552 D201 AA                    tax   
0553 D202 AF C8 B9 00           lda   >v_ptr1+2
0554 D206 A8                    tay   
0555 D207 22 15 FD 00           jsl   >deallocate              ;notify SCM to deallocate space
0556 D20B              ;fall thru to no_path
0557 D20B
0558 D20B              ; The Quit call did not specify a pathname...
0559 D20B
0560 D20B              no_path   
0561 D20B
0562 D20B              ; Since we're not going back to GS/OS, clear the active flag
0563 D20B              ; (this must be done before our first OS call)
0564 D20B
0565 D20B AF BE 00 E1           lda   >os_flag                 ; Clear bit 15 (GS/OS Active Flag)
0566 D20F 0A                    asl   a
0567 D210 4A                    lsr   a
0568 D211 8F BE 00 E1           sta   >os_flag
0569 D215
0570 D215              ; Check the quit flags
0571 D215
0572 D215 AD 7F D6              lda   |e1_quit_flags           ; Is he trying to be put on the stack
0573 D218 10 06                 bpl   flags_ok                 ; without a path to go to?
0574 D21A
0575 D21A              ; If we reach this point, the user did a QUIT with no pathname but with the high
0576 D21A              ; bit of the flag word set.  This is not allowed.  But, since it serves no
0577 D21A              ; purpose to halt the system with a system death message, we now will clear
0578 D21A              ; both currently used flag bits and continue execution.
0579 D21A              ; This means that the program that gave us this incorrect QUIT call will NOT be
0580 D21A              ; restartable from memory and will NOT be put on the program return stack.
0581 D21A
0582 D21A 29 FF 3F              and   #$3fff                   ; Mask off stack and restart flags.
0583 D21D 8D 7F D6              sta   |e1_quit_flags           ; and leave the rest alone.
0584 D220              flags_ok  
0585 D220
0586 D220              ; Decide on the next program to execute.
0587 D220
0588 D220 20 40 D3              jsr   get_next_prog
0589 D223 90 03                 bcc   got_next_prog
0590 D225 4C BC DF     local_fatal jmp   gsos_fatal_err        ;fatal error - no return
0591 D228
0592 D228
0593 D228              ; We now have a program to execute...
0594 D228
0595 D228              got_next_prog  
0596 D228
0597 D228              ; Check if this is the very first call to GQuit.
0598 D228              ; e1_current_id will have a non-zero value except on the very first call.
0599 D228
0600 D228 AD 79 D6              lda   |e1_Current_id
0601 D22B F0 26                 beq   close_files
0602 D22D
0603 D22D              ; Determine if we need to push this id on the stack
0604 D22D
0605 D22D AD 7F D6              lda   |e1_quit_flags           ; Get the Quit call's 'flags' word
0606 D230 10 05                 bpl   no_push_id               ; Skip if no return attribute
0607 D232 20 2E DF              jsr   push_id                  ; Push the id onto ID stack
0608 D235 B0 EE                 bcs   local_fatal              ; fatal error - no return
0609 D237              no_push_id  
0610 D237
0611 D237              ; Call the loader to shutdown the current application.
0612 D237
0613 D237 48                    pha                            ; Stack space for ID result.
0614 D238 AD 79 D6              lda   |e1_Current_id           ; ID of program being shutdown
0615 D23B 48                    pha   
0616 D23C AD 7F D6              lda   |e1_quit_flags           ; Tells loader how to shutdown
0617 D23F 29 00 C0              and   #%1100000000000000       ; Mask bits that the loader doesn't use.
0618 D242 48                    pha   
0619 D243 A2 11 12 22           _usershutdown                  ; Call Loader.
0620 D24A FA                    plx                            ; Discard return ID.
0621 D24B B0 D8                 bcs   local_fatal
0622 D24D
0623 D24D              ; Check if GQuit allocated the current app's ZP and dispose it if we did
0624 D24D
0625 D24D 22 F8 D4 E1           jsl   dispose_user_zp
0626 D251 B0 D2                 bcs   local_fatal
0627 D253
0628 D253              ; Close all open application files by setting the level to zero and doing a CLOSE all.
0629 D253              ; (Ignore errors on these calls.)
0630 D253
0631 D253              close_files  
0632 D253 22 A8 00 E1           _setlevel parms 
0633 D25D 22 A8 00 E1           _close parms
0634 D267
0635 D267              ; Launch the application
0636 D267
0637 D267 4C 9D D3              jmp   launch_app
0638 D26A
0639 D26A
0640 D26A              ;-------------------------------------------------------------------------------
0641 D26A              ; parms
0642 D26A              ;
0643 D26A              ; Parameter table for SetLevel and Close calls
0644 D26A              ;-------------------------------------------------------------------------------
0645 D26A
0646 D26A 00 00        parms    DC B:$00,$00
0647 D26C
0648 D26C
0649 D26C
0650 D26C              ;-------------------------------------------------------------------------------
0651 D26C              ; copy_pathname
0652 D26C              ;
0653 D26C              ; Entry is in 16-bit native mode.
0654 D26C              ; Exit is in 16-bit native mode.
0655 D26C              ; Data bank register is set to bank $E1 on entry and exit.
0656 D26C              ; Direct register is set to GS/OS direct page on entry and exit.
0657 D26C              ;
0658 D26C              ; Inputs:       <path1_ptr - pointer to SCM's copy of the expanded Quit
0659 D26C              ;                            pathname in class 1 format
0660 D26C              ;                            (partial pathnames are expanded by SCM)
0661 D26C              ;
0662 D26C              ; Outputs:      e1_path_ptr - pointer to GQuit's copy of the Quit pathname
0663 D26C              ;               e1_path_hndl - handle to GQuit's copy of the Quit pathname
0664 D26C              ;               A - error code if c=1
0665 D26C              ;               c=0 if no error, else c=1
0666 D26C              ;
0667 D26C              ; This routine makes a copy of the pathname specified in a P16 Quit call.
0668 D26C              ; We have to do this since SCM's copy of the pathname is not locked and
0669 D26C              ; if it moves we're in big trouble.  The reason we can't just lock it and use
0670 D26C              ; it is that if we have to go to P8, the data area in which the pathname lives
0671 D26C              ; is disposed when we shutdown GS/OS.  So, we have to make our own copy.
0672 D26C              ;-------------------------------------------------------------------------------
0673 D26C
0674 D26C                       longa on
0675 D26C                       longi on
0676 D26C                       entry copy_pathname
0677 D26C              copy_pathname  
0678 D26C
0679 D26C              ;first, get the handle associated with the pathname ptr SCM is using
0680 D26C
0681 D26C 48                    pha                            ;space for result
0682 D26D 48                    pha   
0683 D26E D4 3C                 pei   <path1_ptr+2             ;pointer to pathname in SCM land
0684 D270 D4 3A                 pei   <path1_ptr
0685 D272 A2 02 1A 22           _FindHandle 
0686 D279 38                    sec                            ;indicate error just in case
0687 D27A              ;	lda	1,s	;is handle nil?
0688 D27A              ;	ora	3,s
0689 D27A              *** optimized 4-Jun-29 DAL to save two bytes (hooray!)
0690 D27A              ***   A handle can never be $xx0000xx, so checking the middle word is fine.
0691 D27A A3 02                 lda   2,s
0692 D27C              *** end 4-Jun-92 DAL
0693 D27C F0 67                 beq   got_error2               ;yes - so return error (A=0)
0694 D27E
0695 D27E              ;The handle is now on the stack.  Put another copy of the handle on the stack
0696 D27E              ;since both the HLock and HUnLock calls require the handle as input.
0697 D27E
0698 D27E A3 01                 lda   1,s                      ;get lo word of handle
0699 D280 AA                    tax   
0700 D281 A3 03                 lda   3,s                      ;get hi word of handle
0701 D283 48                    pha                            ;push hi word
0702 D284 DA                    phx                            ;push lo word
0703 D285
0704 D285              ;now, lock the handle so that the NewHandle call will not cause the
0705 D285              ;pathname to move
0706 D285
0707 D285 A2 02 20 22           _HLock 
0708 D28C B0 57                 bcs   got_error2
0709 D28E
0710 D28E              ;allocate space so we can make a copy of the pathname
0711 D28E
0712 D28E 48                    pha                            ; reserve space for Handle result
0713 D28F 48                    pha   
0714 D290 A2 00 00              ldx   #$0000
0715 D293 DA                    phx                            ; hi word of seg size ($0000)
0716 D294 A7 3A                 lda   [<path1_ptr]             ; get length of pathname
0717 D296 1A                    inc   a                        ; add 2 for length word
0718 D297 1A                    inc   a
0719 D298 48                    pha                            ; lo word of seg size
0720 D299 AD 69 D6              lda   |e1_path_id              ; segment id
0721 D29C 48                    pha   
0722 D29D F4 18 C0              pea   path_attrib              ; seg attributes word
0723 D2A0 DA                    phx                            ; hi word of seg location ($0000)
0724 D2A1 DA                    phx                            ; lo word of seg location ($0000)
0725 D2A2 A2 02 09 22           _newhandle 
0726 D2A9 B0 38                 bcs   got_error4
0727 D2AB
0728 D2AB              ;save the handle to the allocated space and then dereference the handle
0729 D2AB
0730 D2AB 0B                    phd                            ;save direct register
0731 D2AC 3B                    tsc   
0732 D2AD 5B                    tcd                            ;point direct register at stack
0733 D2AE A5 03                 lda   <3                       ;get handle to memory
0734 D2B0 8D 6B D6              sta   |e1_path_hndl            ;and save
0735 D2B3 A5 05                 lda   <5
0736 D2B5 8D 6D D6              sta   |e1_path_hndl+2
0737 D2B8 A7 03                 lda   [<3]                     ;dereference handle
0738 D2BA 8D 6F D6              sta   |e1_path_ptr             ;and save
0739 D2BD AA                    tax   
0740 D2BE A0 02 00              ldy   #2
0741 D2C1 B7 03                 lda   [<3],y
0742 D2C3 8D 71 D6              sta   |e1_path_ptr+2
0743 D2C6 A8                    tay   
0744 D2C7 2B                    pld                            ;restore direct register
0745 D2C8 68                    pla                            ;clean up stack
0746 D2C9 68                    pla   
0747 D2CA
0748 D2CA              ;store pointer to allocated space on GS/OS direct page
0749 D2CA
0750 D2CA 84 40                 sty   <path2_ptr+2
0751 D2CC 86 3E                 stx   <path2_ptr
0752 D2CE
0753 D2CE              ;copy the pathname from SCM's area into the allocated space
0754 D2CE
0755 D2CE A7 3A                 lda   [<path1_ptr]             ;get length word
0756 D2D0 A8                    tay   
0757 D2D1              loop      
0758 D2D1 B7 3A                 lda   [<path1_ptr],y
0759 D2D3 97 3E                 sta   [<path2_ptr],y
0760 D2D5 88                    dey   
0761 D2D6 F0 F9                 beq   loop
0762 D2D8 88                    dey   
0763 D2D9 10 F6                 bpl   loop
0764 D2DB
0765 D2DB              ;now we can unlock SCM's copy of the pathname
0766 D2DB
0767 D2DB A2 02 22 22           _HUnLock 
0768 D2E2
0769 D2E2              ;return (c and A are set from HLock call)
0770 D2E2
0771 D2E2 60                    rts   
0772 D2E3
0773 D2E3
0774 D2E3              ;got an error from the memory manager so clean up the stack and return error
0775 D2E3
0776 D2E3              got_error4  
0777 D2E3 FA                    plx   
0778 D2E4 FA                    plx   
0779 D2E5              got_error2  
0780 D2E5 FA                    plx   
0781 D2E6 FA                    plx   
0782 D2E7 60                    rts   
0783 D2E8
0784 D2E8                       DataChk on
0785 D2E8                       ENDP 
0786 D2E8
0787 D2E8
0788 D2E8
0789 D2E8                       eject 
0790 D2E8              ;==============================================================================
0791 D2E8              ; initialize_data
0792 D2E8              ;
0793 D2E8              ; Entry is in 16-bit native mode.
0794 D2E8              ; Exit is in 16-bit native mode.
0795 D2E8              ; Data bank register is set to bank $E1 on entry and exit.
0796 D2E8              ; Direct register is unknown.
0797 D2E8              ;
0798 D2E8              ; Inputs:       none
0799 D2E8              ;
0800 D2E8              ; Outputs:      none
0801 D2E8              ;
0802 D2E8              ; This routine sets the initial values of certain variables to zero.
0803 D2E8              ;==============================================================================
0804 D2E8
0805 D2E8              initialize_data PROC 
0806 D2E8                       DataChk off
0807 D2E8
0808 D2E8                       longa on
0809 D2E8                       longi on
0810 D2E8
0811 D2E8 9C 7F D6              stz   |e1_quit_flags
0812 D2EB 9C 7B D6              stz   |e1_open_id
0813 D2EE 9C 83 D6              stz   |e1_load_type
0814 D2F1 9C 87 D6              stz   |e1_start_flag
0815 D2F4 9C 8F D6              stz   |e1_os_switch
0816 D2F7 9C E5 D7              stz   |e1_p8quit_path
0817 D2FA 9C 6F D6              stz   |e1_path_ptr
0818 D2FD 9C 71 D6              stz   |e1_path_ptr+2
0819 D300 9C 6B D6              stz   |e1_path_hndl
0820 D303 9C 6D D6              stz   |e1_path_hndl+2
0821 D306 9C 73 D6              stz   |e1_path_len
0822 D309 60                    rts   
0823 D30A
0824 D30A                       DataChk on
0825 D30A                       ENDP 
0826 D30A
0827 D30A
0828 D30A
0829 D30A                       eject 
0830 D30A              ;==============================================================================
0831 D30A              ; copy_volname
0832 D30A              ;
0833 D30A              ; Entry is in 16-bit native mode.
0834 D30A              ; Exit is in 16-bit native mode.
0835 D30A              ; Data bank register is set to bank $E1 on entry and exit.
0836 D30A              ; Direct register is preserved.
0837 D30A              ;
0838 D30A              ; Inputs:       e1_path_ptr - points to the expanded Quit pathname
0839 D30A              ;               c - 0 if e1_path_ptr points to a class 0 string
0840 D30A              ;                   1 if e1_path_ptr points to a class 1 string
0841 D30A              ;
0842 D30A              ; Outputs:      e1_app_volname - contains the volume name (class 0 always)
0843 D30A              ;
0844 D30A              ; Copies the volume name from the expanded Quit pathname into e1_app_volname
0845 D30A              ; for use by the 'mount volume' routine.
0846 D30A              ;==============================================================================
0847 D30A
0848 D30A              copy_volname PROC 
0849 D30A                       DataChk off
0850 D30A
0851 D30A 0B                    phd                            ;save direct register
0852 D30B AD 71 D6              lda   |e1_path_ptr+2           ;push string ptr onto stack
0853 D30E 48                    pha   
0854 D30F AD 6F D6              lda   |e1_path_ptr
0855 D312 48                    pha   
0856 D313 3B                    tsc                            ;set direct register to point to stack
0857 D314 5B                    tcd   
0858 D315
0859 D315                       longa off
0860 D315                       longi off
0861 D315 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
0862 D317
0863 D317 A0 01                 ldy   #1                       ;assume class 0 string to start
0864 D319 A2 01                 ldx   #1                       ;skip length byte
0865 D31B A9 2F                 lda   #'/'                     ;separator to look for
0866 D31D 48                    pha   
0867 D31E 90 05                 bcc   class0
0868 D320 C8                    iny                            ;class 1 string so skip another byte
0869 D321 A9 3A                 lda   #':'                     ;different separator to look for
0870 D323 83 01                 sta   1,s
0871 D325              class0    
0872 D325
0873 D325 A9 2F                 lda   #'/'                     ;store beginning slash
0874 D327 9D 3B D7              sta   |e1_app_volname,x
0875 D32A
0876 D32A E8           loop     inx   
0877 D32B C8                    iny   
0878 D32C B7 01                 lda   [<1],y                   ;copy volume name
0879 D32E 9D 3B D7              sta   |e1_app_volname,x
0880 D331 C3 01                 cmp   1,s
0881 D333 D0 F5                 bne   loop                     ;loop until hit a separator
0882 D335
0883 D335 CA           done     dex                            ;don't count the separator
0884 D336 8E 3B D7              stx   |e1_app_volname          ;store length byte
0885 D339 68                    pla                            ;pull separator off stack
0886 D33A
0887 D33A                       longa on
0888 D33A                       longi on
0889 D33A C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
0890 D33C
0891 D33C 68                    pla                            ;pull pointer off stack
0892 D33D 68                    pla   
0893 D33E 2B                    pld                            ;restore direct register
0894 D33F 60                    rts   
0895 D340
0896 D340                       DataChk on
0897 D340                       ENDP 
0898 D340
0899 D340
0900 D340
0901 D340                       eject 
0902 D340              ;==============================================================================
0903 D340              ; get_next_prog
0904 D340              ;
0905 D340              ; Entry is in 16-bit native mode.
0906 D340              ; Exit is in 16-bit native mode.
0907 D340              ; Data bank register is set to bank $E1 on entry and exit.
0908 D340              ;
0909 D340              ; Inputs:       none
0910 D340              ;
0911 D340              ; Outputs:      e1_open_id - id of next program to execute if stack not empty
0912 D340              ;               A - error code if c=1
0913 D340              ;               c=0 if no error, else c=1
0914 D340              ;
0915 D340              ; The Quit call didn't specify a pathname to link to so pop the ID stack.
0916 D340              ; If the ID stack is empty, execute the program launcher
0917 D340              ;==============================================================================
0918 D340
0919 D340              get_next_prog PROC 
0920 D340                       DataChk off
0921 D340                       Import call_launcher
0922 D340
0923 D340                       longa on
0924 D340                       longi on
0925 D340
0926 D340              ; We have no program to link to so pop the ID stack to see if we have a
0927 D340              ; program to return to.
0928 D340
0929 D340 20 54 DF              jsr   Pop_id                   ; Pop the ID stack
0930 D343 90 57                 bcc   done                     ; carry set if stack is empty
0931 D345
0932 D345              ; We have no program to link to and nothing on the stack to return to.
0933 D345              ; So, default to the start program if we're currently running P8, or
0934 D345              ; run the Program Launcher if we're running GS/OS.
0935 D345
0936 D345 AD 81 D6              lda   |e1_current_os           ;which OS is running?
0937 D348 30 3C                 bmi   its_p8
0938 D34A
0939 D34A AD 7F D6              lda   e1_quit_flags            ;is the app smart enough to be restarted?
0940 D34D 29 00 10              and   #%0001000000000000
0941 D350 D0 2B                 bne   @restart_it              ;yes, just restart the start app
0942 D352
0943 D352              ; Since there's no userID on the quit stack to quit to, we'll bring in the Program Launcher
0944 D352              ; to allow the user to interactively select the next application to launch.
0945 D352
0946 D352 AF F6 B9 00           lda   >sys_prefs               ;get current system preferences
0947 D356 48                    pha                            ;save around call to program launcher
0948 D357 A9 00 00              lda   #0                       ;set to not display mount dialog
0949 D35A 8F F6 B9 00           sta   >sys_prefs
0950 D35E
0951 D35E 22 33 D4 E1           jsl   call_launcher            ;go execute the program launcher
0952 D362
0953 D362 68                    pla                            ;retrieve SysPrefs
0954 D363 8F F6 B9 00           sta   >sys_prefs               ;restore original setting
0955 D367
0956 D367 DA                    phx                            ;save returned userID
0957 D368 DA                    phx                            ;twice
0958 D369
0959 D369 20 6C D2              jsr   copy_pathname            ;copy pathname into our own data area
0960 D36C
0961 D36C A2 02 11              ldx   #$1102                   ;DisposeAll
0962 D36F 22 00 00 E1           jsl   $E10000                  ;(userid already on stack)
0963 D373
0964 D373 A2 03 21              ldx   #$2103                   ;DeleteID (id already on stack)
0965 D376 22 00 00 E1           jsl   $E10000
0966 D37A
0967 D37A 38                    sec                            ;it's a class 1 string
0968 D37B 80 19                 bra   continue2                ;then continue as before
0969 D37D
0970 D37D              @restart_it  
0971 D37D A2 A1 D7              ldx   #e1_start_prog1          ;GS/OS is in so we need a class 1 string
0972 D380 A0 E1 00              ldy   #e1_start_prog1>>16
0973 D383 38                    sec                            ;class 1 string for 'copy_volname'
0974 D384 80 0A                 bra   cont
0975 D386
0976 D386              its_p8    
0977 D386 EE 87 D6              inc   |e1_start_flag           ;indicate we're launching start prog
0978 D389
0979 D389 A2 5E D7              ldx   #e1_start_prog0          ;P8 is in so we need a class 0 string
0980 D38C A0 E1 00              ldy   #e1_start_prog0>>16
0981 D38F 18                    clc                            ;class 0 string for 'copy_volname'
0982 D390
0983 D390 8E 6F D6     cont     stx   |e1_path_ptr             ;store pointer to correct string
0984 D393 8C 71 D6              sty   |e1_path_ptr+2
0985 D396              continue2  
0986 D396 20 0A D3              jsr   copy_volname             ;copy volname for mount_volume window
0987 D399
0988 D399 20 98 DC              jsr   get_info_sub
0989 D39C 60           done     rts                            ;carry clear if no error, else set
0990 D39D
0991 D39D                       DataChk on
0992 D39D                       ENDP 
0993 D39D
0994 D39D
0995 D39D
0996 D39D                       eject 
0997 D39D              ;==============================================================================
0998 D39D              ; launch_app
0999 D39D              ;
1000 D39D              ; Entry is in 16-bit native mode.
1001 D39D              ; Exit is in 16-bit native mode.
1002 D39D              ; Data bank register is set to bank $E1 on entry and exit.
1003 D39D              ;
1004 D39D              ; Inputs:       none
1005 D39D              ;
1006 D39D              ; Outputs:      none
1007 D39D              ;
1008 D39D              ; Shut down the Desk Manager in case the application didn't to ensure
1009 D39D              ; that no interrupt routines will be calling GS/OS or ProDOS 8 incorrectly.
1010 D39D              ; Then determine if application is P8 or P16 and jump to correct routine.
1011 D39D              ;
1012 D39D              ; The DeskShutDown call can cause memory to move so it must be done after
1013 D39D              ; the Quit pathname has been copied into our own locked data area.
1014 D39D              ;
1015 D39D              ; NOTE: We don't want to deallocate interrupts.  If we're not switching
1016 D39D              ; operating systems, they probably want to live if the QUITing application
1017 D39D              ; didn't deallocate them.  If we are switching operating systems, the handlers
1018 D39D              ; are going to be overwritten and we can, and will, shut off known Apple //gs
1019 D39D              ; interrupt sources before going to ProDOS 8.  However, we haven't any way to
1020 D39D              ; shut off hardware interrupts from some unknown source, so if interrupts are
1021 D39D              ; still running...CRASH!!!
1022 D39D              ;==============================================================================
1023 D39D
1024 D39D              launch_app PROC 
1025 D39D                       DataChk off
1026 D39D
1027 D39D                       longa on
1028 D39D                       longi on
1029 D39D
1030 D39D A2 05 03 22           _DeskShutDown 
1031 D3A4
1032 D3A4 AD 83 D6              lda   |e1_Load_Type            ; Get load type
1033 D3A7 C9 FF 00              cmp   #$00ff                   ; Is it P8?
1034 D3AA F0 03                 beq   launch_p8app             ; yes
1035 D3AC 4C 5B D8              jmp   launch_p16app            ; no, so must be P16 app
1036 D3AF
1037 D3AF                       eject 
1038 D3AF              ;===============================================================================
1039 D3AF              ; launch_p8app
1040 D3AF              ;
1041 D3AF              ; Entry is in 16-bit native mode.
1042 D3AF              ; Exit is in 16-bit native mode.
1043 D3AF              ;
1044 D3AF              ; Data bank register is set to bank $E1 on entry.
1045 D3AF              ; Direct register is set to GS/OS direct page at $00BD00 on entry from p16quit.
1046 D3AF              ; Direct register is set to $000000 on entry from p8quit.
1047 D3AF              ; Stack pointer is set to GQuit's stack on entry from p16quit.
1048 D3AF              ; Stack pointer is set to $01xx on entry from p8quit.
1049 D3AF              ;
1050 D3AF              ; Data bank register is set to bank $00 on exit.
1051 D3AF              ; Direct register is set to $0000 on exit.
1052 D3AF              ; Stack pointer is set to $01fb on exit.
1053 D3AF              ;
1054 D3AF              ; Attempt to launch a P8 application.
1055 D3AF              ;===============================================================================
1056 D3AF
1057 D3AF              launch_p8app  
1058 D3AF                       longa on
1059 D3AF                       longi on
1060 D3AF
1061 D3AF
1062 D3AF AD 81 D6              lda   |e1_current_os           ; Check to see which OS is running.
1063 D3B2 10 07                 bpl   its_gsos                 ; It's GS/OS.
1064 D3B4 A9 FB 01              lda   #$01fb                   ; set stack at $01fb for emulation mode
1065 D3B7 1B                    tcs   
1066 D3B8 4C 91 D6              jmp   its_P8                   ; It's ProDOS 8.
1067 D3BB
1068 D3BB              ;-------------------------------------------------------------------------------
1069 D3BB
1070 D3BB              its_gsos  
1071 D3BB                       Import e1_fst_id
1072 D3BB
1073 D3BB AD FD D5              lda   |e1_fst_id               ;make sure that the P8 application resides
1074 D3BE C9 01 00              cmp   #proDOSFSID              ; on a ProDOS or AppleShare volume
1075 D3C1 F0 0B                 beq   @continue
1076 D3C3 C9 0D 00              cmp   #appleShareFSID
1077 D3C6 F0 06                 beq   @continue
1078 D3C8 A2 41 00              ldx   #65                      ;non-fatal error message
1079 D3CB 4C 85 D4              jmp   no_can_do
1080 D3CE              @continue  
1081 D3CE
1082 D3CE              ; Indicate that we are switching operating systems.
1083 D3CE
1084 D3CE EE 8F D6              inc   |e1_os_switch
1085 D3D1
1086 D3D1              ; Set OS_Kind to $ff to indicate that we are switching operating systems
1087 D3D1              ; and that interrupt tasks should not make OS calls
1088 D3D1
1089 D3D1                       longa off
1090 D3D1                       longi off
1091 D3D1 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
1092 D3D3
1093 D3D3 A9 FF                 lda   #$ff
1094 D3D5 8D BC 00              sta   |OS_Kind
1095 D3D8
1096 D3D8 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
1097 D3DA                       longa on
1098 D3DA                       longi on
1099 D3DA
1100 D3DA              ; We are currently using class 1 strings so convert them to class 0 strings...
1101 D3DA
1102 D3DA              ; First, check to see if we're relaunching the start program.
1103 D3DA              ; If so, change e1_path_ptr to point to the start program's class 0 pathname.
1104 D3DA
1105 D3DA AD 87 D6              lda   |e1_start_flag           ;are we relaunching the start prog?
1106 D3DD F0 0E                 beq   not_start                ;no
1107 D3DF
1108 D3DF A9 5E D7              lda   #e1_start_prog0          ;yes - so get pointer to class 0 string
1109 D3E2 8D 6F D6              sta   |e1_path_ptr
1110 D3E5 A9 E1 00              lda   #e1_start_prog0>>16
1111 D3E8 8D 71 D6              sta   |e1_path_ptr+2
1112 D3EB 80 18                 bra   get_gsos_pfx
1113 D3ED
1114 D3ED              not_start  
1115 D3ED
1116 D3ED              ; The Quit call specified the pathname of a program to link to.
1117 D3ED              ; First, convert the class 1 string to a class 0 string.
1118 D3ED
1119 D3ED AE 71 D6              ldx   |e1_path_ptr+2           ;push ptr to source string (class 1)
1120 D3F0 DA                    phx   
1121 D3F1 AC 6F D6              ldy   |e1_path_ptr
1122 D3F4 5A                    phy   
1123 D3F5 DA                    phx                            ;push ptr to dest string (class 0)
1124 D3F6 5A                    phy   
1125 D3F7 22 78 FC 01           jsl   >cvt_1to0                ;convert class 1 string to class 0
1126 D3FB
1127 D3FB              ; Now, convert the class 1 separators (:) to class 0 separators (/).
1128 D3FB
1129 D3FB AC 71 D6              ldy   |e1_path_ptr+2           ;get pointer to string in X and Y
1130 D3FE AE 6F D6              ldx   |e1_path_ptr
1131 D401 22 6C D3 E1           jsl   colon_2_slash            ;replace colons with slashes
1132 D405
1133 D405              ; Get the correct GS/OS prefix which will be used to set ProDOS 8's prefix.
1134 D405
1135 D405              get_gsos_pfx  
1136 D405 AD 7D D6              lda   |e1_quit_prefix          ;get Quit call's pathname prefix
1137 D408 C9 20 00              cmp   #32                      ;was the prefix '*' ?
1138 D40B D0 0F                 bne   not_star                 ;no
1139 D40D 22 A8 00 E1           _getbootvol e1_gbv_parms       ;class 0 call
1140 D417 90 3C                 bcc   class0_pfx
1141 D419 4C BC DF              jmp   gsos_fatal_err           ;fatal error - no return
1142 D41C
1143 D41C              not_star  
1144 D41C 9C 95 D5              stz   |e1_getpfx_num           ;initialize to prefix 0
1145 D41F C9 FF FF              cmp   #$ffff                   ;was a prefix specified?
1146 D422 F0 03                 beq   get_zero                 ;no - so get prefix 0
1147 D424 8D 95 D5              sta   |e1_getpfx_num           ;yes - so get the specified prefix
1148 D427              get_zero  
1149 D427 22 A8 00 E1           _getprefix1 e1_getpfx_parms1   ;class 1 call
1150 D431 90 08                 bcc   prefix_ok
1151 D433 C9 4F 00              cmp   #buff_too_small          ;if buffer was too small then prefix
1152 D436 F0 45                 beq   its_too_long             ;was > 65 chars so report syntax err
1153 D438 4C BC DF              jmp   gsos_fatal_err           ;fatal error - no return
1154 D43B              prefix_ok  
1155 D43B
1156 D43B              ; Now, convert the prefix string from class 1 to class 0
1157 D43B
1158 D43B F4 E1 00              pea   e1_prefix_buf>>16        ;push ptr to source string (class 1)
1159 D43E F4 2A D8              pea   e1_prefix_buf
1160 D441 F4 E1 00              pea   e1_prefix_buf>>16        ;push ptr to dest string (class 0)
1161 D444 F4 2A D8              pea   e1_prefix_buf
1162 D447 22 78 FC 01           jsl   >cvt_1to0                ;convert class 1 string to class 0
1163 D44B
1164 D44B              ; Now, convert the class 1 separators (:) to class 0 separators (/).
1165 D44B
1166 D44B A0 E1 00              ldy   #e1_prefix_buf>>16       ;get string pointer in X and Y
1167 D44E A2 2A D8              ldx   #e1_prefix_buf
1168 D451 22 6C D3 E1           jsl   colon_2_slash            ;replace colons with slashes
1169 D455
1170 D455              class0_pfx  
1171 D455
1172 D455              ; Check to make sure that the length of the pathname minus the length of
1173 D455              ; the prefix (if specified) is less than 65 characters.
1174 D455
1175 D455 F4 00 00              pea   0                        ;init prefix length to 0
1176 D458 AD 7D D6              lda   |e1_quit_prefix          ;was a prefix specified?
1177 D45B 30 08                 bmi   no_prefix                ;no
1178 D45D AD 2A D8              lda   |e1_prefix_buf           ;yes - so put prefix length on stack
1179 D460 29 FF 00              and   #$00ff
1180 D463 83 01                 sta   1,s
1181 D465              no_prefix  
1182 D465 AD 6F D6              lda   |e1_path_ptr
1183 D468 85 3A                 sta   <path1_ptr               ;store string ptr on GS/OS direct page
1184 D46A AD 71 D6              lda   |e1_path_ptr+2           ;we can use path1_ptr as a temp
1185 D46D 85 3C                 sta   <path1_ptr+2
1186 D46F 38                    sec   
1187 D470 A7 3A                 lda   [<path1_ptr]             ;get length
1188 D472 29 FF 00              and   #$00ff                   ;mask off hi byte
1189 D475
1190 D475 E3 01                 sbc   1,s                      ;subtract length of prefix
1191 D477 FA                    plx                            ;clean up stack
1192 D478 C9 41 00              cmp   #p8_max_length+1         ;is it longer than maximum P8 pathname?
1193 D47B 90 17                 bcc   length_ok                ;no
1194 D47D
1195 D47D              its_too_long  
1196 D47D AD 7F D6              lda   |e1_quit_flags           ;was previous app put on ID stack?
1197 D480 10 0C                 bpl   cant_cancel              ;no
1198 D482 A2 37 00              ldx   #p8_path_err             ;message #
1199 D485              no_can_do  
1200 D485 20 8A DF              jsr   gsos_nonfatal            ;put up non-fatal error
1201 D488 20 54 DF              jsr   pop_id                   ;pop ID of previous app off stack
1202 D48B 4C 5B D8              jmp   launch_p16app            ;and relaunch it
1203 D48E
1204 D48E              cant_cancel                             ;can't recover so put up fatal error msg
1205 D48E A2 38 00              ldx   #p8_path_err2            ;message #
1206 D491 4C BF DF              jmp   gsos_fatal_err2          ;fatal error - no return
1207 D494
1208 D494              length_ok  
1209 D494
1210 D494              ; Check to see if we have a copy of the P8 file in memory
1211 D494
1212 D494 AD 67 D6              lda   |e1_p8copy_flag          ;do we have a saved copy of P8?
1213 D497 30 05                 bmi   no_copy                  ;no
1214 D499 20 36 D7              jsr   deref_and_lock           ;yes - so deref and lock the handle
1215 D49C 90 2F                 bcc   notify_q                 ;carry set if block was purged
1216 D49E              no_copy   
1217 D49E
1218 D49E              ; Go load the P8 file...
1219 D49E              ; First, try to open the P8 file.
1220 D49E
1221 D49E 22 A8 00 E1  open_call _open1 e1_open_parms1         ; Open the P8 file.
1222 D4A8 90 1C                 bcc   open_p8_ok
1223 D4AA
1224 D4AA C9 46 00              cmp   #file_not_found          ;was the error 'file not found' ?
1225 D4AD D0 69                 bne   local_fatal              ;no - so put up fatal error message
1226 D4AF
1227 D4AF AD 7F D6              lda   |e1_quit_flags           ;was previous app put on ID stack?
1228 D4B2 10 0C                 bpl   no_pop_back              ;no - so put up fatal error message
1229 D4B4
1230 D4B4 A2 14 00              ldx   #no_p8_err               ;message #
1231 D4B7 20 8A DF              jsr   gsos_nonfatal            ;put up non-fatal error
1232 D4BA 20 54 DF              jsr   pop_id                   ;pop ID of previous app off stack
1233 D4BD 4C 5B D8              jmp   launch_p16app            ;and relaunch it
1234 D4C0
1235 D4C0              no_pop_back                             ;can't recover so put up fatal error msg
1236 D4C0 A2 12 00              ldx   #no_p8_err2              ;message #
1237 D4C3 4C BF DF              jmp   gsos_fatal_err2          ;fatal error - no return
1238 D4C6
1239 D4C6              open_p8_ok  
1240 D4C6
1241 D4C6              *** added 4-Jun-92 DAL, mainly for EtherTalk card
1242 D4C6              ; Call OS_P8_Switch vector with A = $0001 for leaving-GS/OS, for
1243 D4C6              ; things like the ETalk driver, which have no convenient way to
1244 D4C6              ; instally a notify proc on ROM 1.
1245 D4C6
1246 D4C6 A9 01 00              lda   #$0001
1247 D4C9 22 B4 00 E1           jsl   >os_p8_switch
1248 D4CD              *** end 4-Jun-92
1249 D4CD
1250 D4CD              ; Notify the OS event queue that we are just about to switch to ProDOS 8.
1251 D4CD              ; The Direct register must be set to GS/OS direct page for the call to SCM.
1252 D4CD
1253 D4CD              notify_q  
1254 D4CD 48                    pha                            ; push 3 words of garbage
1255 D4CE 48                    pha   
1256 D4CF 48                    pha   
1257 D4D0 A9 02 00              lda   #switch_to_p8            ;lo word of the event code
1258 D4D3 A2 00 00              ldx   #>switch_to_p8           ;hi word of the event code
1259 D4D6 22 00 B3 00           jsl   >os_event                ;call SCM
1260 D4DA
1261 D4DA              ; If we have a copy of the P8 file in memory, then copy it down to $2000
1262 D4DA
1263 D4DA AD 67 D6              lda   |e1_p8copy_flag
1264 D4DD C9 01 00              cmp   #1                       ;do we have a valid handle?
1265 D4E0 D0 1E                 bne   read_p8                  ;no - so read in the file from disk
1266 D4E2
1267 D4E2 AD 61 D6              lda   |e1_p8copy_ptr+2         ;hi word of src
1268 D4E5 48                    pha   
1269 D4E6 AD 5F D6              lda   |e1_p8copy_ptr           ;lo word of src
1270 D4E9 48                    pha   
1271 D4EA A9 00 00              lda   #$0000
1272 D4ED 48                    pha                            ;hi word of dest ($0000)
1273 D4EE F4 00 20              pea   $2000                    ;lo word of dest
1274 D4F1 48                    pha                            ;hi word of xfer count ($0000)
1275 D4F2 AD 63 D6              lda   |e1_p8copy_size          ;lo word of xfer count
1276 D4F5 48                    pha   
1277 D4F6 F4 05 08              pea   move_sinc_dinc           ;command byte
1278 D4F9 22 70 FC 01           jsl   >move_info               ;call SCM to do the copy
1279 D4FD 4C B4 D5              jmp   p8copy_done
1280 D500
1281 D500              ; The file is open, so now read it into memory at $2000 and close the file.
1282 D500
1283 D500              read_p8   
1284 D500 AD AD D5              lda   |e1_open_ref             ; Put ref no. into other parm lists
1285 D503 8D B7 D5              sta   |e1_close_ref
1286 D506 8D CB D5              sta   |e1_geof_ref
1287 D509 8D BB D5              sta   |e1_read_ref
1288 D50C
1289 D50C 22 A8 00 E1           _geteof1 e1_geof_parms1        ; Get # of bytes in P8 file
1290 D516 90 03                 bcc   eof_ok
1291 D518 4C BC DF     local_fatal jmp   gsos_fatal_err        ; fatal error - no return
1292 D51B              eof_ok    
1293 D51B
1294 D51B AD CD D5              lda   |e1_geof_eof             ; get # of bytes to read
1295 D51E 8D 63 D6              sta   |e1_p8copy_size          ; save
1296 D521 8D C1 D5              sta   |e1_read_count           ; only low word is needed
1297 D524 9C C3 D5              stz   |e1_read_count+2         ; High word is zero
1298 D527
1299 D527 22 A8 00 E1           _read1 e1_read_parms1          ; Read in P8
1300 D531 B0 E5                 bcs   local_fatal
1301 D533
1302 D533 22 A8 00 E1           _close1 e1_close_parms1        ; Close the P8 file
1303 D53D B0 D9                 bcs   local_fatal
1304 D53F
1305 D53F              ; ProDOS 8 is now loaded at $2000.  Check the "GS/OS compatibility byte".
1306 D53F
1307 D53F AD CD D5              lda   |e1_geof_eof             ;get size of P8 file
1308 D542 C9 E8 42              cmp   #p8_file_eof             ;is it the correct size?
1309 D545 D0 0C                 bne   bad_version              ;no
1310 D547 AF FA 2E 00           lda   >P8_compat_byte          ;size is OK so get the compatibility byte
1311 D54B 29 FF 00              and   #$00FF                   ;mask off hi byte
1312 D54E C9 04 00              cmp   #P8_compat_value
1313 D551 F0 06                 beq   version_ok
1314 D553 A2 0E 00     bad_version ldx   #p8_version_err       ;message #
1315 D556 4C BF DF              jmp   gsos_fatal_err2          ;fatal error - no return
1316 D559              version_ok  
1317 D559
1318 D559              ; Save a copy of the P8 file in non-special memory
1319 D559
1320 D559 48                    pha                            ;space for Handle result
1321 D55A 48                    pha   
1322 D55B F4 00 00              pea   $0000                    ;hi word of size
1323 D55E AD 63 D6              lda   |e1_p8copy_size          ;lo word of size
1324 D561 48                    pha   
1325 D562 AD 59 D6              lda   |e1_p8copy_id            ;user id
1326 D565 48                    pha   
1327 D566 F4 08 01              pea   p8copy_attrib            ;attributes
1328 D569 48                    pha                            ;loc ptr - unused
1329 D56A 48                    pha   
1330 D56B
1331 D56B AD 67 D6              lda   |e1_p8copy_flag          ;do we have a purged handle?
1332 D56E F0 13                 beq   realloc                  ;yes - so reallocate it
1333 D570
1334 D570 A2 02 09 22           _newhandle                     ;allocate a new handle
1335 D577 FA                    plx   
1336 D578 7A                    ply   
1337 D579 B0 48                 bcs   p8copy_done2             ;got an error - don't report it
1338 D57B 8E 5B D6              stx   |e1_p8copy_hndl
1339 D57E 8C 5D D6              sty   |e1_p8copy_hndl+2
1340 D581 80 13                 bra   copy_p8
1341 D583
1342 D583              realloc   
1343 D583 AD 5D D6              lda   |e1_p8copy_hndl+2        ;purged handle
1344 D586 48                    pha   
1345 D587 AD 5B D6              lda   |e1_p8copy_hndl
1346 D58A 48                    pha   
1347 D58B A2 02 0A 22           _ReAllocHandle                 ;reallocate it
1348 D592 FA                    plx                            ;clean up stack
1349 D593 FA                    plx   
1350 D594 B0 2D                 bcs   p8copy_done2             ;got an error - don't report it
1351 D596
1352 D596              copy_p8   
1353 D596 20 36 D7              jsr   deref_and_lock           ;dereference and lock the handle
1354 D599
1355 D599 A2 00 00              ldx   #$0000
1356 D59C DA                    phx                            ;hi word of src ($0000)
1357 D59D F4 00 20              pea   $2000                    ;lo word of src
1358 D5A0 AD 61 D6              lda   |e1_p8copy_ptr+2         ;hi word of dest
1359 D5A3 48                    pha   
1360 D5A4 AD 5F D6              lda   |e1_p8copy_ptr           ;lo word of dest
1361 D5A7 48                    pha   
1362 D5A8 DA                    phx                            ;hi word of xfer count ($0000)
1363 D5A9 AD 63 D6              lda   |e1_p8copy_size          ;lo word of xfer count
1364 D5AC 48                    pha   
1365 D5AD F4 05 08              pea   $0805                    ;command byte
1366 D5B0 22 70 FC 01           jsl   >move_info               ;call SCM to do the copy
1367 D5B4
1368 D5B4              ; We're done with the copy of P8 so unlock the block
1369 D5B4
1370 D5B4              p8copy_done  
1371 D5B4 AD 5D D6              lda   |e1_p8copy_hndl+2
1372 D5B7 48                    pha   
1373 D5B8 AD 5B D6              lda   |e1_p8copy_hndl
1374 D5BB 48                    pha   
1375 D5BC A2 02 22 22           _HUnlock 
1376 D5C3              p8copy_done2  
1377 D5C3
1378 D5C3              ; Tell the Slot Arbiter to save the slot 3 screenholes since the ProDOS 8 loader
1379 D5C3              ; will enable the internal slot 3 rom.  Do NOT check for errors on this call.
1380 D5C3
1381 D5C3 A9 03 00              lda   #$0003                   ;slot 3
1382 D5C6 22 BC FC 01           jsl   >dyn_slot_arbiter
1383 D5CA 8E 95 D6              stx   |e1_besc                 ;save the "bit encoded slot configuration"
1384 D5CD
1385 D5CD              ; Save the slot 3 rom status (internal vs external) since the ProDOS 8 loader
1386 D5CD              ; will enable the internal slot 3 rom and we need to restore the correct value
1387 D5CD              ; when we eventually get back to GS/OS.
1388 D5CD
1389 D5CD E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
1390 D5CF AF 17 C0 00           lda   >rdc3rom                 ;get slot 3 status
1391 D5D3 8D 93 D6              sta   |e1_c3_status            ;and save
1392 D5D6 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
1393 D5D8
1394 D5D8              ; Notify SCM that it should do an EndSession call and then close all open application
1395 D5D8              ; files and all open system files and write them out to disk if necessary.
1396 D5D8              ; (must be done before the device dispatcher is shutdown)
1397 D5D8              ; (Direct register must be set to GS/OS direct page)
1398 D5D8
1399 D5D8 22 13 D5 00           jsl   >close_all_files
1400 D5DC
1401 D5DC              ; Indicate that GS/OS is no longer in a valid state so that the report_fatal routine
1402 D5DC              ; will not try to shutdown GS/OS if a fatal error occurs.
1403 D5DC
1404 D5DC 9C E9 D6              stz   |e1_gsos_ok
1405 D5DF
1406 D5DF              ; Shut down the device dispatcher.
1407 D5DF              ; (must be done before SCM is shutdown)
1408 D5DF              ; (Direct register must be set to GS/OS direct page)
1409 D5DF
1410 D5DF 64 00                 stz   <drvr_dev_num            ;device number = dispatcher
1411 D5E1 A9 02 00              lda   #2
1412 D5E4 85 02                 sta   <drvr_call_num           ;call number = shutdown
1413 D5E6 22 00 FC 01           jsl   >dev_dispatcher
1414 D5EA B0 06                 bcs   local_fatal2
1415 D5EC
1416 D5EC              ; Shut down SCM.
1417 D5EC              ; (Direct register must be set to GS/OS direct page)
1418 D5EC
1419 D5EC 22 7E D4 00           jsl   >shutdown_scm
1420 D5F0 90 03                 bcc   scm_ok
1421 D5F2 4C BC DF     local_fatal2 jmp   gsos_fatal_err       ; fatal error - no return
1422 D5F5              scm_ok    
1423 D5F5
1424 D5F5 F4 00 00              pea   0                        ; code for switch from GS/OS to P8
1425 D5F8 A2 11 1F              ldx   #$1F11                   ; internal function number for SwitchHandler
1426 D5FB 22 00 00 E1           jsl   $E10000                  ; notify the loader that we're switching
1427 D5FF
1428 D5FF              ; Now, let's effectively take out the loader as a tool so it won't be called on
1429 D5FF              ; a control reset, or on a call to the reset routine in the firmware.  We will
1430 D5FF              ; do this by making a SetTSPtr call with the loader's tool number, and pointing
1431 D5FF              ; the function table pointer to a location containing 2 bytes of zeros.  The 2
1432 D5FF              ; zero bytes are the count of how many functions there are in the tool set.
1433 D5FF              ; The Dispatcher will read this zero, and know not to bother making the TLReset
1434 D5FF              ; call to the loader.
1435 D5FF
1436 D5FF F4 00 00              pea   0                        ; Loader is a System toolset
1437 D602 F4 11 00              pea   Loader_TSN               ; loader's tool set #
1438 D605 F4 E1 00              pea   zero_word>>16            ; Push hi byte of adrs of zero word
1439 D608 F4 BA 00              pea   zero_word**$ff           ; Push lo byte of adrs of zero word
1440 D60B A2 01 0A 22           _setTSPtr                      ; Install the ptr to our zero word
1441 D612
1442 D612              ; Patch the GS/OS entry vectors to jump to the QuickDraw patches which are at the
1443 D612              ; start of the error messages file.  This is done so that if a P8 app starts up QuickDraw
1444 D612              ; (which is a legal thing to do), QuickDraw won't crash when it tries to make GS/OS calls
1445 D612              ; (which it shouldn't be doing).  The GS/OS entry vectors are restored to their proper
1446 D612              ; values by the init_SCM routine in SCM.
1447 D612
1448 D612 AD E1 D6              lda   |e1_patch1_adr           ; get load address of first patch and
1449 D615 8D B1 00              sta   |$e100b0+1               ; store it in the GS/OS stack entry vector after the JML
1450 D618 AD E2 D6              lda   |e1_patch1_adr+1         ;ignore hi byte of load address
1451 D61B 8D B2 00              sta   |$e100b0+2
1452 D61E
1453 D61E AD E5 D6              lda   |e1_patch2_adr           ; get load address of second patch and
1454 D621 8D A9 00              sta   |$e100a8+1               ; store it in the GS/OS normal entry vector after the JML
1455 D624 AD E6 D6              lda   |e1_patch2_adr+1         ;ignore hi byte of load address
1456 D627 8D AA 00              sta   |$e100a8+2
1457 D62A
1458 D62A              ; Compact memory so that we have a better chance of getting storage space for GS/OS
1459 D62A
1460 D62A A2 02 1F 22           _CompactMem 
1461 D631
1462 D631              ; Allocate memory to store GS/OS in while ProDOS 8 is running
1463 D631
1464 D631 9C 8D D6              stz   |e1_no_storage           ;init flag to indicate that we got storage
1465 D634 20 AA DE              jsr   alloc_storage            ;allocate storage areas for GS/OS
1466 D637 90 09                 bcc   storage_ok               ;did we get all the storage areas we need?
1467 D639 22 EC D4 E1           jsl   dispose_storage          ;no - so get rid of the storage areas we got
1468 D63D EE 8D D6              inc   |e1_no_storage           ;indicate that we don't have storage areas
1469 D640 80 12                 bra   dispose_os               ;skip over some code
1470 D642              storage_ok  
1471 D642
1472 D642              ; Move the B0 code to bank 0 where it must run from.
1473 D642
1474 D642 A2 00 D0              ldx   #<b0e1_obj_pstn          ; source address of code to relocate
1475 D645 A0 00 82              ldy   #b0_obj_pstn             ; dest address
1476 D648 A9 FF 01              lda   #b0_obj_size-1           ; # of bytes to move - 1.
1477 D64B 8B                    phb                            ; save data bank reg
1478 D64C 54 00 E1              mvn   $E10000,0                ; move from bank $E1 to bank $00
1479 D64F AB                    plb                            ; restore data bank reg
1480 D650
1481 D650              ; Copy parts of GS/OS into storage areas  (this is B0 code)
1482 D650
1483 D650 22 4B 82 00           jsl   copy_gsos_segs
1484 D654
1485 D654              ; Dispose of any memory which GQuit or GLDR allocated for GS/OS.
1486 D654
1487 D654              dispose_os  
1488 D654 22 E7 D4 E1           jsl   dispose_os_mem
1489 D658 B0 98                 bcs   local_fatal2
1490 D65A
1491 D65A              ; Now allocate all of special memory for ProDOS 8.
1492 D65A
1493 D65A 20 59 DE              jsr   alloc_p8_mem
1494 D65D B0 93                 bcs   local_fatal2
1495 D65F
1496 D65F              ; Set direct register to emulation zero page ($000000) for ProDOS 8.
1497 D65F
1498 D65F A9 00 00              lda   #$0000
1499 D662 5B                    tcd   
1500 D663
1501 D663              ; Set stack to $01fb for ProDOS 8.
1502 D663
1503 D663 A9 FB 01              lda   #$01fb
1504 D666 1B                    tcs   
1505 D667
1506 D667              ; Now we must move the code that calls ProDOS 8's loader to bank 0
1507 D667              ; because we must go into emulation mode and have the ROM banked in!
1508 D667
1509 D667 8B                    phb                            ; Save current DBR.
1510 D668 A2 65 D7              ldx   #setup_P8_begin          ; Source adr. of Bank 0 code to reloc.
1511 D66B A0 00 02              ldy   #$0000200                ; Dest adr. (origin) of bank 0 code.
1512 D66E A9 5A 00              lda   #setup_P8_end-setup_P8_begin-1 ; # of bytes to move - 1.
1513 D671 54 00 E0              mvn   $E00000,0                ; move from bank $E0 to bank 0
1514 D674
1515 D674              ; Call ProDOS 8's loader and patch ProDOS 8  (DBR is set to 0 from previous MVN)
1516 D674
1517 D674 22 00 02 00           jsl   >$000200                 ; call setup_p8
1518 D678 AB                    plb                            ; Restore DBR.
1519 D679
1520 D679              ; Update e1_current_os since we have just changed to ProDOS 8.
1521 D679
1522 D679 A9 00 80              lda   #$8000
1523 D67C 8D 81 D6              sta   |e1_current_os
1524 D67F
1525 D67F              ; Move GS/OS's prefix down to $0200 so we can set ProDOS 8's prefix
1526 D67F
1527 D67F                       longa off
1528 D67F                       longi off
1529 D67F E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
1530 D681
1531 D681 AD 2A D8              lda   |e1_prefix_buf           ; get length byte
1532 D684 AA                    tax   
1533 D685 BD 2A D8     move_pfx lda   |e1_prefix_buf,x
1534 D688 9F 00 02 00           sta   >$000200,x
1535 D68C CA                    dex   
1536 D68D 10 F6                 bpl   move_pfx
1537 D68F
1538 D68F                       longa on
1539 D68F                       longi on
1540 D68F C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
1541 D691
1542 D691              ; fall into next section
1543 D691
1544 D691              ;-------------------------------------------------------------------------------
1545 D691
1546 D691              its_p8    
1547 D691
1548 D691              ; Set current_id to zero since it is now undefined.
1549 D691
1550 D691 9C 79 D6              stz   |e1_current_id
1551 D694
1552 D694              ; Set the SHADOW register up for P8 applications and set OS_Kind to $00
1553 D694              ; to indicate that ProDOS 8 is running
1554 D694
1555 D694                       longa off
1556 D694                       longi off
1557 D694 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
1558 D696
1559 D696 AF 35 C0 00           lda   >shadow
1560 D69A 29 20                 and   #text_page_2_bit         ; preserve state of text page 2 shadowing
1561 D69C 09 08                 ora   #P8_shadowmask           ; All shadowing on (//e simulation)
1562 D69E 8F 35 C0 00           sta   >shadow
1563 D6A2
1564 D6A2 9C BC 00              stz   |OS_Kind                 ; 0 signifies that P8 is running
1565 D6A5
1566 D6A5                       longa on
1567 D6A5                       longi on
1568 D6A5 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
1569 D6A7
1570 D6A7              ; Call the first routine in the auto linked chain of routines that
1571 D6A7              ; need to know when the OS is going to be changed.
1572 D6A7              ; (This must be done before we start making P8 calls.)
1573 D6A7
1574 D6A7 22 AC 00 E1           jsl   >OS_Switch               ; Notify the routines.
1575 D6AB
1576 D6AB              ; Strip the prefix off the application's pathname if a partial pathname
1577 D6AB              ; was specified in the Quit call
1578 D6AB
1579 D6AB AD 7D D6              lda   |e1_quit_prefix          ;was it a partial pathname?
1580 D6AE 30 2F                 bmi   store_path               ;no - so don't have to strip off prefix
1581 D6B0
1582 D6B0 AD 6F D6              lda   |e1_path_ptr             ;put ptr to pathname on direct page
1583 D6B3 85 00                 sta   <0
1584 D6B5 AD 71 D6              lda   |e1_path_ptr+2
1585 D6B8 85 02                 sta   <2
1586 D6BA
1587 D6BA                       longa off
1588 D6BA                       longi off
1589 D6BA E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
1590 D6BC
1591 D6BC 38                    sec   
1592 D6BD A7 00                 lda   [0]                      ;get length byte of full pathname
1593 D6BF ED 2A D8              sbc   |e1_prefix_buf           ;subtract length byte of prefix
1594 D6C2 AC 2A D8              ldy   |e1_prefix_buf           ;to create length of partial pathname
1595 D6C5 97 00                 sta   [0],y                    ;store just before partial pathname
1596 D6C7
1597 D6C7                       longa on
1598 D6C7                       longi on
1599 D6C7 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
1600 D6C9
1601 D6C9 18                    clc                            ;adjust e1_path_ptr to point to the
1602 D6CA AD 2A D8              lda   |e1_prefix_buf           ;partial pathname
1603 D6CD 29 FF 00              and   #$00ff
1604 D6D0 6D 6F D6              adc   |e1_path_ptr
1605 D6D3 8D 6F D6              sta   |e1_path_ptr
1606 D6D6 AD 71 D6              lda   |e1_path_ptr+2
1607 D6D9 69 00 00              adc   #0
1608 D6DC 8D 71 D6              sta   |e1_path_ptr+2
1609 D6DF
1610 D6DF              ; Store the application's pathname at $280 abiding by P8's conventions.
1611 D6DF
1612 D6DF              store_path  
1613 D6DF AD 6F D6              lda   |e1_path_ptr
1614 D6E2 85 00                 sta   <0
1615 D6E4 AD 71 D6              lda   |e1_path_ptr+2
1616 D6E7 85 02                 sta   <2
1617 D6E9
1618 D6E9                       longa off
1619 D6E9                       longi off
1620 D6E9 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
1621 D6EB
1622 D6EB A7 00                 lda   [<0]                     ;get length byte
1623 D6ED A8                    tay   
1624 D6EE AA                    tax   
1625 D6EF
1626 D6EF B7 00        move_loop lda   [<0],y
1627 D6F1 9F 80 02 00           sta   >$000280,x
1628 D6F5 88                    dey   
1629 D6F6 CA                    dex   
1630 D6F7 10 F6                 bpl   move_loop
1631 D6F9
1632 D6F9                       longa on
1633 D6F9                       longi on
1634 D6F9 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
1635 D6FB
1636 D6FB              ; If we got here from a P16 Quit call which specified a pathname, we must now
1637 D6FB              ; deallocate the space we obtained for the copy of the pathname
1638 D6FB              ; since we are done using the pathname.
1639 D6FB
1640 D6FB 22 1B D5 E1           jsl   dispose_path
1641 D6FF 90 03                 bcc   dispose_ok
1642 D701 4C D2 DF              jmp   p8_fatal_err2            ;fatal error - no return
1643 D704              dispose_ok  
1644 D704
1645 D704 AF 00 10 00           lda   >$1000                   ; does the quit code start with a CLD? ($D8)
1646 D708 29 FF 00              and   #$00FF
1647 D70B C9 D8 00              cmp   #$00D8
1648 D70E F0 09                 beq   @move_launcher           ; yes, so it's not our custom launch code
1649 D710 AF 0E 10 00           lda   >$100E                   ; pick up the ID bytes
1650 D714 C9 47 51              cmp   #'G'+('Q'<<8)            ; is it GQuit's custom launcher?
1651 D717 F0 0C                 beq   @do_launch               ; yes, we can use it!
1652 D719
1653 D719              @move_launcher  
1654 D719
1655 D719              ; Now move the application's loading code into bank zero since it
1656 D719              ; makes ProDOS 8 calls.
1657 D719
1658 D719 A2 C0 D7              ldx   #setup_p8_end            ; Source adr. of code to move.
1659 D71C A0 10 10              ldy   #load_app_begin          ; Dest adr. of code.
1660 D71F A9 9A 00              lda   #load_app_end-load_app_begin-1 ; # of bytes to move - 1.
1661 D722 54 00 E0              mvn   $E00000,0                ; MVN from bank $e0 to $00.
1662 D725
1663 D725              ; Data bank register is now set to bank $00 from previous MVN.
1664 D725
1665 D725              @do_launch  
1666 D725 F4 00 00              pea   0                        ;must set DBR to 0 for emulation mode
1667 D728 AB                    plb   
1668 D729 AB                    plb   
1669 D72A
1670 D72A              ; Decrement the system busy flag
1671 D72A
1672 D72A 22 68 00 E1           jsl   >decbusyflg
1673 D72E
1674 D72E              ; Load and run the program.
1675 D72E
1676 D72E
1677 D72E AF 8F D6 E1           lda   >e1_os_switch            ;must pass value of this flag to P8 launcher
1678 D732 5C 10 10 00           jmp   >$001010                 ;jump to relocated QUIT code
1679 D736
1680 D736
1681 D736
1682 D736              ;---------------------------------------------------------------------------------
1683 D736              ; deref_and_lock
1684 D736              ;
1685 D736              ; Entry is in 16-bit native mode.
1686 D736              ; Exit is in 16-bit native mode.
1687 D736              ; Data bank register is set to bank $E1 on entry and exit.
1688 D736              ; Direct register is set to GS/OS direct page at $00BD00 on entry and exit.
1689 D736              ; Stack pointer is set to GQuit's stack on entry and exit.
1690 D736              ;
1691 D736              ; Inputs:       e1_p8copy_hndl - handle to copy of P8
1692 D736              ;
1693 D736              ; Outputs:      c - 1 if handle was purged; 0 if handle is valid
1694 D736              ;               e1_p8copy_ptr - ptr to copy of P8 (if e1_p8copy_hndl is valid)
1695 D736              ;               e1_p8copy_flag - 0 if handle was purged, 1 if handle is valid
1696 D736              ;
1697 D736              ; Dereference and lock e1_p8copy_hndl.
1698 D736              ;---------------------------------------------------------------------------------
1699 D736
1700 D736              deref_and_lock  
1701 D736                       longa on
1702 D736                       longi on
1703 D736
1704 D736 9C 67 D6              stz   |e1_p8copy_flag          ;indicate that we have a purged handle
1705 D739 38                    sec                            ;ditto
1706 D73A
1707 D73A AD 5B D6              lda   |e1_p8copy_hndl          ;put handle on direct page
1708 D73D 85 3A                 sta   <path1_ptr               ;we can use path1_ptr
1709 D73F AD 5D D6              lda   |e1_p8copy_hndl+2
1710 D742 85 3C                 sta   <path1_ptr+2
1711 D744
1712 D744 A7 3A                 lda   [<path1_ptr]             ;dereference the handle
1713 D746 8D 5F D6              sta   |e1_p8copy_ptr
1714 D749 A0 02 00              ldy   #2
1715 D74C B7 3A                 lda   [<path1_ptr],y
1716 D74E 8D 61 D6              sta   |e1_p8copy_ptr+2
1717 D751 0D 5F D6              ora   |e1_p8copy_ptr           ;has the handle been purged?
1718 D754 F0 0E                 beq   d_and_l_done             ;yes
1719 D756
1720 D756 A0 04 00              ldy   #4
1721 D759 B7 3A                 lda   [<path1_ptr],y           ;get attributes
1722 D75B 09 00 80              ora   #$8000                   ;lock the segment
1723 D75E 97 3A                 sta   [<path1_ptr],y
1724 D760 EE 67 D6              inc   |e1_p8copy_flag          ;indicate that we have a valid handle
1725 D763 18                    clc                            ;ditto
1726 D764
1727 D764 60           d_and_l_done rts   
1728 D765
1729 D765                       DataChk on
1730 D765                       ENDP 
1731 D765
1732 D765                       eject 
1733 D765              ;===============================================================================
1734 D765              ; setup_p8
1735 D765              ;
1736 D765              ; Entry is in 16-bit native mode.
1737 D765              ; Exit is in 16-bit native mode.
1738 D765              ; Data bank register is set to bank $00 on entry and exit.
1739 D765              ; Direct register is set to $0000 on entry and exit.
1740 D765              ; Stack pointer is set to $01xx on entry and exit.
1741 D765              ;
1742 D765              ; Inputs:       none
1743 D765              ;
1744 D765              ; Outputs:      none
1745 D765              ;
1746 D765              ; Notes:        This code is moved to $00/0200 and executed there.
1747 D765              ;===============================================================================
1748 D765
1749 D765              setup_P8 PROC 
1750 D765
1751 D765                       EXPORT setup_P8_begin
1752 D765              setup_P8_begin  
1753 D765
1754 D765                       longa off
1755 D765                       longi off
1756 D765 38                    sec   
1757 D766 FB                    xce                            ;***** begin emulation mode *****
1758 D767
1759 D767              *** 23-Oct-92 DAL -- Zero is a nasty problem when it gets left in
1760 D767              ***   DEVNUM.  Let's lie and say $50 instead.
1761 D767              ;;;	stz	$43	;zero P8's boot device ID
1762 D767 A9 50                 lda   #$50
1763 D769 85 43                 sta   $43
1764 D76B              *** end 23-Oct-92
1765 D76B
1766 D76B
1767 D76B              ; Now call the alternate entry point in the ProDOS 8 loader that
1768 D76B              ; will set up ProDOS 8, but instead of executing a system program,
1769 D76B              ; will return to the caller.
1770 D76B
1771 D76B AD 81 C0              lda   |romin                   ; Enable ROM for ProDOS.
1772 D76E 20 06 20              jsr   $2006                    ; use new GQuit entry point
1773 D771 AC 8B C0              ldy   |lcbank1                 ; R/W enable LCb1 for GQUIT.
1774 D774 AC 8B C0              ldy   |lcbank1
1775 D777
1776 D777 18                    clc   
1777 D778 FB                    xce                            ;***** return to 8-bit native *****
1778 D779
1779 D779
1780 D779              ; *** gab ***
1781 D779              ; Need to patch the P8 kernel to first move the dispatcher code from $D100 to $1000.
1782 D779              ; After it's moved, we can  check the P8 quit parameters for the signature byte ($EE)
1783 D779              ; signifying a pathname quit.  If it is, we  can go directly to GQuit.  If it's a normal
1784 D779              ; quit, we should transfer control to $1000 (the dispatcher code).  This way, if the user
1785 D779              ; has installed their own dispatcher code over our code, the user's dispatcher will gain
1786 D779              ; control (instead of going off to GQuit).
1787 D779              ; *** end ***
1788 D779
1789 D779              ; Now enable LCb1 to patch the P8 kernel. This patch will check to see
1790 D779              ; if the P8 quit call was a pathname quit with $ee as an input parameter,
1791 D779              ; and if so jump directly to GQUIT.  If not, then it will move the three
1792 D779              ; pages at $d100 LCb2 to $1000 and jmp $1000 as usual.
1793 D779
1794 D779 AC 8B C0              ldy   |lcbank1
1795 D77C
1796 D77C AD FD FE              lda   |p8calldisp_adr          ;get the address of p8calldisp
1797 D77F 85 00                 sta   <0                       ;and store on zero page
1798 D781 AD FE FE              lda   |p8calldisp_adr+1
1799 D784 85 01                 sta   <1
1800 D786
1801 D786 A0 2C                 ldy   #patch_size-1            ;get length of patch
1802 D788 B9 2E 02     lkoop    lda   |patch_begin-setup_p8_begin+$200,y
1803 D78B 91 00                 sta   (<0),y                   ; This is the patch address!
1804 D78D 88                    dey   
1805 D78E 10 F8                 bpl   lkoop
1806 D790
1807 D790                       longa on
1808 D790                       longi on
1809 D790 C2 30                 rep   #$30                     ; Return in 16 bit mode.
1810 D792 6B                    rtl                            ; Back to GQUIT!
1811 D793
1812 D793
1813 D793              ;-------------------------------------------------------------------------------
1814 D793              ; P8calldisp patch
1815 D793              ;
1816 D793              ; This is the patch code that patches the code in ProDOS that moves the 3
1817 D793              ; pages of quit code from $d100 in bank0 lc to $1000.  Beware that if the
1818 D793              ; patched code changes in size, this patch must do the same.  Also beware
1819 D793              ; that if the contents of $bf04,$bf05 (currently it's CALLDISP) changes, this
1820 D793              ; patch must do the same.
1821 D793              ;-------------------------------------------------------------------------------
1822 D793
1823 D793              patch_begin  
1824 D793                       longa off
1825 D793                       longi off
1826 D793              max_size equ   $2D                      ;maximum size the patch can grow to
1827 D793              bra_target equ   patch_begin+max_size
1828 D793
1829 D793              ; *** gab ***
1830 D793              ; this has been rearranged so that the move is done prior to checking for the signature
1831 D793              ; byte.  This is so that the launcher code is in place whether it's a normal quit or
1832 D793              ; a pathname quit.
1833 D793 AD 83 C0              lda   |lcbank2                 ; R/W enable LCb2
1834 D796 AD 83 C0              lda   |lcbank2
1835 D799
1836 D799                       longa on
1837 D799                       longi on
1838 D799 18                    clc                            ; *** gab *** go into native mode
1839 D79A FB                    xce   
1840 D79B C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
1841 D79D
1842 D79D A2 00 D1              ldx   #$D100                   ;source of move
1843 D7A0 A0 00 10              ldy   #$1000                   ;destination of move
1844 D7A3 A9 FF 02              lda   #$300-1                  ;move $300 bytes
1845 D7A6 54 00 00              mvn   0,0                      ;move within bank 0
1846 D7A9
1847 D7A9                       longa off
1848 D7A9                       longi off
1849 D7A9 E2 30                 sep   #$30                     ; *** gab *** 8 bit mode
1850 D7AB
1851 D7AB AD 8B C0              lda   |lcbank1                 ; R/W enable LCb1
1852 D7AE AD 8B C0              lda   |lcbank1
1853 D7B1
1854 D7B1 A0 01                 ldy   #1
1855 D7B3 B1 40                 lda   ($40),y                  ;get quit param
1856 D7B5 C9 EE                 cmp   #$ee                     ;is it this?
1857 D7B7 D0 04                 bne   jjjj                     ;no it's not, do the move, like always
1858 D7B9 5C 00 D0 E0           jmp   >P8quit                  ;yes it is, go to pquit
1859 D7BD
1860 D7BD              jjjj      
1861 D7BD                       longa off
1862 D7BD                       longi off
1863 D7BD 38                    sec   
1864 D7BE FB                    xce                            ;***** begin emulation mode *****
1865 D7BF
1866 D7BF              if (*-patch_begin) = max_size-1 then  
1867 D7BF EA                    nop                            ;dummy byte to let execution fall through
1868 D7C0              elseif (*-patch_begin) < max_size then  
1869 D7C0                       bra   bra_target               ;must jump around left-over garbage
1870 D7C0              else      
1871 D7C0                                                      ; just let the code fall into the original code
1872 D7C0              endif     
1873 D7C0
1874 D7C0              patch_size equ   *-patch_begin          ;size of this patch
1875 D7C0
1876 D7C0                if patch_size>max_size then  
1877 D7C0                  aerror &concat('P8 Quit patch too long by $', &i2s(patch_size-max_size,-4,1), ' bytes!')  
1878 D7C0                endif   
1879 D7C0
1880 D7C0
1881 D7C0                       EXPORT setup_P8_end
1882 D7C0              setup_P8_end  
1883 D7C0
1884 D7C0                       ENDP 
1885 D7C0
1886 D7C0
1887 D7C0                       eject 
1888 D7C0
1889 D7C0              ; The functionality of this segment has been placed in an alternate dispatcher
1890 D7C0              ; segment that is copied to bank 2 of the language card by the P8 setup routine
1891 D7C0              ; within P8 itself.  This copy is here so that we can copy it down to bank
1892 D7C0              ; 0 and use it when the normal quit routine has been overwritten by a user-
1893 D7C0              ; installed Quit routine (such as ProSel).
1894 D7C0              ;
1895 D7C0              ; The alternate dispatcher code resides at $1010 in memory after a P8 quit call.
1896 D7C0              ; The first 14 bytes of $1000 area of memory is reserved for the patch that forces
1897 D7C0              ; the quit call to jump to P8Quit, with the bytes at $100E and $100F reserved for
1898 D7C0              ; GQuit's ID bytes (currently 'GQ').
1899 D7C0              ;===============================================================================
1900 D7C0              ; load_app
1901 D7C0              ;
1902 D7C0              ; Entry is in 16-bit native mode.
1903 D7C0              ; Exit is in emulation mode.
1904 D7C0              ; Data bank register is set to bank $00 on entry and exit.
1905 D7C0              ; Direct register is set to $0000 on entry and exit.
1906 D7C0              ; Stack pointer is set to $01fb on entry and exit.
1907 D7C0              ;
1908 D7C0              ; Inputs:       Acc = value of e1_OS_Switch
1909 D7C0              ;
1910 D7C0              ; Outputs:      none
1911 D7C0              ;
1912 D7C0              ; Notes:        This code is moved to $00/1010 and executed there.
1913 D7C0              ;
1914 D7C0              ; Loads and executes a ProDOS 8 application.
1915 D7C0              ;===============================================================================
1916 D7C0
1917 D7C0              load_app PROC tempOrg $1010
1918 D7C0                       DataChk Off
1919 D7C0                       CodeChk Off
1920 D7C0
1921 D7C0                       EXPORT load_app_begin
1922 D7C0              load_app_begin  
1923 D7C0
1924 D7C0              ; Go into emulation mode to load and run ProDOS 8 application.
1925 D7C0
1926 D7C0                       longa off
1927 D7C0                       longi off
1928 D7C0 38                    sec   
1929 D7C1 FB                    xce                            ;***** begin emulation mode *****
1930 D7C2
1931 D7C2 AA                    tax                            ; Are we switching from P16 to P8?
1932 D7C3 F0 0D                 beq   load_it                  ; no
1933 D7C5
1934 D7C5              ; We are switching from P16 to P8, so we must pass prefix 0 from P16 to
1935 D7C5              ; the P8 prefix.
1936 D7C5
1937 D7C5 20 00 BF     setpfx_call jsr   |ProDOS8
1938 D7C8 C6                    DC B:p8_setpfx_num             ;command number
1939 D7C9 93 10                 DC W:p8_setpfx_list            ;parameter list
1940 D7CB 90 05                 bcc   setpfx_ok
1941 D7CD 20 7C 10              jsr   p8error2                 ; handle error.
1942 D7D0 80 F3                 bra   setpfx_call              ; try again.
1943 D7D2              setpfx_ok  
1944 D7D2
1945 D7D2              ; Now, load in the application beginning at $2000.
1946 D7D2
1947 D7D2              load_it   
1948 D7D2
1949 D7D2              ; Open the application file.
1950 D7D2
1951 D7D2 20 00 BF     open_call jsr   |ProDOS8
1952 D7D5 C8                    DC B:p8_open_num
1953 D7D6 96 10                 DC W:p8_open_list
1954 D7D8 90 05                 bcc   open_ok
1955 D7DA 20 68 10              jsr   p8error                  ; handle error.
1956 D7DD 80 F3                 bra   open_call                ; try again.
1957 D7DF              open_ok   
1958 D7DF
1959 D7DF              ; Do a GetEOF call so we know how many bytes to read.
1960 D7DF
1961 D7DF 20 00 BF     eof_call jsr   |ProDOS8
1962 D7E2 D1                    DC B:p8_eof_num
1963 D7E3 9C 10                 DC W:p8_eof_list
1964 D7E5 90 05                 bcc   eof_ok
1965 D7E7 20 68 10              jsr   p8error                  ; handle error.
1966 D7EA 80 F3                 bra   eof_call                 ; try again.
1967 D7EC              eof_ok    
1968 D7EC
1969 D7EC              ; Get the size of the file and store in the Read parameter list.
1970 D7EC
1971 D7EC AD 9E 10              lda   |p8_eof
1972 D7EF 8D A5 10              sta   |p8_read_count
1973 D7F2 AD 9F 10              lda   |p8_eof+1
1974 D7F5 8D A6 10              sta   |p8_read_count+1
1975 D7F8
1976 D7F8              ; Read in the application.
1977 D7F8
1978 D7F8 20 00 BF     read_call jsr   |ProDOS8
1979 D7FB CA                    DC B:p8_read_num
1980 D7FC A1 10                 DC W:p8_read_list
1981 D7FE 90 05                 bcc   read_ok
1982 D800 20 68 10              jsr   p8error                  ; handle error.
1983 D803 80 F3                 bra   read_call                ; try again.
1984 D805              read_ok   
1985 D805
1986 D805              ; Close the application file.
1987 D805
1988 D805 20 00 BF     close_call jsr   |ProDOS8
1989 D808 CC                    DC B:p8_close_num
1990 D809 A9 10                 DC W:p8_close_list
1991 D80B 90 05                 bcc   close_ok
1992 D80D 20 68 10              jsr   p8error                  ; handle error.
1993 D810 80 F3                 bra   close_call               ; try again.
1994 D812              close_ok  
1995 D812
1996 D812              ;*** added 23-Oct-92 DAL -- If UNIT ($43) is still zero, make it something else,
1997 D812              ;***   because zero is dangerous (if fed to ON_LINE, for example, it will return
1998 D812              ;***   much more data than expected).  This should only be zero in the somewhat
1999 D812              ;***   strange case that you network-booted into GS/OS, and then switched to P8
2000 D812              ;***   but have so many devices online that your boot volume isn't in DEVLST.
2001 D812              ;	lda	$bf30
2002 D812              ;	bne	@okay
2003 D812              ;	lda	#$50
2004 D812              ;	sta	$bf30
2005 D812              ;@okay
2006 D812              ;*** end 22-Oct-92
2007 D812
2008 D812              ; Now, execute the application.
2009 D812
2010 D812 AD 81 C0              lda   |romin                   ; Enable ROM.
2011 D815 4C 00 20              jmp   $2000                    ; Execute the application.
2012 D818
2013 D818              ;-------------------------------------------------------------------------------
2014 D818
2015 D818              p8error   
2016 D818 AC 8B C0              ldy   |lcbank1                 ; Enable LCb1 for error routines
2017 D81B AC 8B C0              ldy   |lcbank1
2018 D81E
2019 D81E 18                    clc   
2020 D81F FB                    xce                            ;***** begin native mode *****
2021 D820 C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
2022 D822
2023 D822 22 00 D2 E1           jsl   p8_mount_vol
2024 D826 90 18                 bcc   ret_pressed
2025 D828 5C CF DF E0           jmp   >p8_fatal_err
2026 D82C
2027 D82C              p8error2  
2028 D82C AC 8B C0              ldy   |lcbank1                 ; Enable LCb1 for error routines
2029 D82F AC 8B C0              ldy   |lcbank1
2030 D832
2031 D832 18                    clc   
2032 D833 FB                    xce                            ;***** begin native mode *****
2033 D834 C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
2034 D836
2035 D836 22 53 D2 E1           jsl   p8_prefix_err
2036 D83A 90 04                 bcc   ret_pressed
2037 D83C 5C CF DF E0           jmp   >p8_fatal_err
2038 D840
2039 D840              ret_pressed  
2040 D840 38                    sec   
2041 D841 FB                    xce                            ;***** return to emulation mode *****
2042 D842 60                    rts   
2043 D843
2044 D843
2045 D843              ;-------------------------------------------------------------------------------
2046 D843              ; ProDOS 8 parameter lists
2047 D843              ;-------------------------------------------------------------------------------
2048 D843
2049 D843              p8_setpfx_list                          ; Set prefix parameter list.
2050 D843 01                    DC B:1                         ; Number of parameters is 1.
2051 D844 00 02                 DC W:$200                      ; Address of where prefix is.
2052 D846
2053 D846              p8_open_list  
2054 D846 03                    DC B:3                         ; Parameter count is 3.
2055 D847 80 02                 DC W:$280                      ; Pathname is at $280.
2056 D849 00 1C                 DC W:$1c00                     ; I/O buffer location.
2057 D84B 00                    DS B:1                         ; Reference number
2058 D84C
2059 D84C              p8_eof_list  
2060 D84C 02                    DC B:2                         ; Number of parameters is 2.
2061 D84D 01                    DC B:1                         ; Reference number is 1 (Only open file).
2062 D84E 00 00 00     p8_eof   DS B:3                         ; 3 byte EOF value.
2063 D851
2064 D851              p8_read_list  
2065 D851 04                    DC B:4                         ; Number of parameters is 4.
2066 D852 01                    DC B:1                         ; Reference number is 1.
2067 D853 00 20                 DC W:$2000                     ; Read into $2000. (Bank 0 of course)
2068 D855 00 00        p8_read_count DS B:2                    ; Number of bytes to read.
2069 D857 00 00                 DS B:2                         ; Transfer count.
2070 D859
2071 D859              p8_close_list  
2072 D859 01                    DC B:1                         ; Number of parameters is 1.
2073 D85A 01                    DC B:1                         ; Close reference number is 1.
2074 D85B
2075 D85B                       EXPORT load_app_end
2076 D85B              load_app_end  
2077 D85B
2078 D85B                       DataChk On
2079 D85B                       CodeChk On
2080 D85B                       ENDP 
2081 D85B
2082 D85B
2083 D85B
2084 D85B                       eject 
2085 D85B              ;===============================================================================
2086 D85B              ; launch_p16app
2087 D85B              ;
2088 D85B              ; Entry is in 16-bit native mode.
2089 D85B              ; Exit is in 8-bit native mode.
2090 D85B              ;
2091 D85B              ; Data bank register is set to bank $E1 on entry.
2092 D85B              ; Direct register is set to GS/OS direct page at $00BD00 on entry from p16quit.
2093 D85B              ; Direct register is set to $000000 on entry from p8quit.
2094 D85B              ; Stack pointer is set to GQuit's stack on entry from p16quit.
2095 D85B              ; Stack pointer is set to $01xx on entry from p8quit.
2096 D85B              ;
2097 D85B              ; Data bank register is set to bank $E1 on exit.
2098 D85B              ; Direct register is set to application's direct page on exit.
2099 D85B              ; Stack pointer is set to application's stack on exit.
2100 D85B              ;
2101 D85B              ; Attempt to launch a P16 application.
2102 D85B              ;===============================================================================
2103 D85B
2104 D85B              launch_p16app PROC 
2105 D85B                       DataChk off
2106 D85B                       Import gsos_nonfatal2
2107 D85B
2108 D85B                       longa on
2109 D85B                       longi on
2110 D85B
2111 D85B AD 81 D6              lda   |e1_current_os           ;Check to see which OS is running.
2112 D85E 30 03                 bmi   its_P8                   ;It's ProDOS 8.
2113 D860 4C 98 D9              jmp   its_gsos                 ;It's GS/OS.
2114 D863
2115 D863              ;-------------------------------------------------------------------------------
2116 D863
2117 D863              its_p8    
2118 D863
2119 D863 AD 8D D6              lda   |e1_no_storage           ; do we have GS/OS storage areas?
2120 D866 F0 04                 beq   storage_ok               ; yes - so continue
2121 D868 5C F6 EF 00           jmp   >restart_system          ; call SCM to restart the system
2122 D86C              storage_ok  
2123 D86C
2124 D86C              *** NOTE THAT A = $0000 HERE, EVEN IN 6.0 (4-Jun-92 DAL)
2125 D86C
2126 D86C              ; Let everybody know that P8 is going away before it actually goes away
2127 D86C
2128 D86C 22 B4 00 E1           jsl   >os_p8_switch            ; A = $0000 for leaving P8
2129 D870
2130 D870              ; Indicate that we are switching operating systems.
2131 D870
2132 D870 EE 8F D6              inc   |e1_os_switch
2133 D873
2134 D873              ; Set OS_Kind to $ff to indicate that we are switching operating systems
2135 D873              ; and that interrupt tasks should not make OS calls
2136 D873
2137 D873                       longa off
2138 D873                       longi off
2139 D873 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
2140 D875
2141 D875 A9 FF                 lda   #$ff
2142 D877 8D BC 00              sta   |OS_Kind
2143 D87A
2144 D87A C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
2145 D87C                       longa on
2146 D87C                       longi on
2147 D87C
2148 D87C              ; Dispose of ProDOS 8's reserved memory segments
2149 D87C
2150 D87C 22 E7 D4 E1           jsl   dispose_os_mem
2151 D880 90 03                 bcc   dispose_ok
2152 D882 4C D2 DF     local_p8_fatal jmp   p8_fatal_err2      ;fatal error - no return
2153 D885              dispose_ok  
2154 D885
2155 D885              ; Allocate GS/OS's reserved memory segments
2156 D885
2157 D885 22 2F DE E0           jsl   alloc_gsos_mem
2158 D889 B0 F7                 bcs   local_p8_fatal
2159 D88B
2160 D88B              ; Move the B0 code to bank 0 where it must run from
2161 D88B
2162 D88B A2 00 D0              ldx   #<b0e1_obj_pstn          ; source address of code to relocate
2163 D88E A0 00 82              ldy   #b0_obj_pstn             ; dest address
2164 D891 A9 FF 01              lda   #b0_obj_size-1           ; # of bytes to move - 1.
2165 D894 8B                    phb                            ; save data bank reg
2166 D895 54 00 E1              mvn   $E10000,0                ; move from bank $E1 to bank $00
2167 D898 AB                    plb                            ; restore data bank reg
2168 D899
2169 D899              ; Clear the screen and put up the "One moment please..." message  (this is B0 code)
2170 D899
2171 D899 22 00 82 00           jsl   display_msg
2172 D89D
2173 D89D              ; Copy GS/OS back into its assigned locations  (this is B0 code)
2174 D89D
2175 D89D 22 4B 82 00           jsl   copy_gsos_segs
2176 D8A1
2177 D8A1              ; Now set the stack to GQuit's own stack.
2178 D8A1              ; But before we do, we must check what the stack is currently set to.
2179 D8A1              ; If it's Page 1 we must set $010100 to the value in S.
2180 D8A1
2181 D8A1 3B                    tsc                            ; get current stack
2182 D8A2 29 00 FF              and   #$FF00                   ; look at high byte
2183 D8A5 C9 00 01              cmp   #$0100                   ; is it 1?
2184 D8A8 D0 09                 bne   set_new_stack            ; no, so never mind
2185 D8AA 3B                    tsc                            ; get it again
2186 D8AB E2 30                 sep   #$30                     ; go into 8 bit mode
2187 D8AD 8F 00 01 01           sta   >mnemstkptr              ; store it
2188 D8B1 C2 30                 rep   #$30                     ; back to 16 bit mode
2189 D8B3 A9 FF BC     set_new_stack lda   #gquit_stack_top    ; set stack to GQuit's own stack
2190 D8B6 1B                    tcs   
2191 D8B7
2192 D8B7              ; Make sure our error messages are not suppressed
2193 D8B7
2194 D8B7 AF F6 B9 00           lda   >sys_prefs               ;get preferences flag
2195 D8BB 29 FF DF              and   #$DFFF                   ;clear bit 13
2196 D8BE 8F F6 B9 00           sta   >sys_prefs
2197 D8C2
2198 D8C2              ; Dispose of GS/OS storage areas
2199 D8C2
2200 D8C2 22 EC D4 E1           jsl   dispose_storage
2201 D8C6 B0 3A                 bcs   local_gs_fatal
2202 D8C8
2203 D8C8              ; Now, let's re-install the loader as a tool
2204 D8C8
2205 D8C8 F4 00 00              pea   0                        ; indicate this is a System toolset
2206 D8CB F4 11 00              pea   Loader_TSN               ; loader's tool set #
2207 D8CE F4 01 00              pea   #^Loader_Entry
2208 D8D1 F4 00 A6              pea   #<Loader_Entry
2209 D8D4 A2 01 0A 22           _setTSPtr 
2210 D8DB
2211 D8DB F4 01 00              pea   1                        ; code for switch from P8 to GS/OS
2212 D8DE A2 11 1F              ldx   #$1F11                   ; internal function number for SwitchHandler
2213 D8E1 22 00 00 E1           jsl   $E10000
2214 D8E5
2215 D8E5              ; Now restart GS.OS.DEV
2216 D8E5
2217 D8E5 AD ED D6              lda   |e1_dev_address+2        ; get hi word of entry address
2218 D8E8 EB                    xba                            ; swap bytes
2219 D8E9 8F F6 D8 E0           sta   >dev_adr+2               ; and store below
2220 D8ED AD EB D6              lda   |e1_dev_address          ; get lo word of entry address
2221 D8F0 8F F5 D8 E0           sta   >dev_adr+1               ; and store below
2222 D8F4 22 F4 D8 E0  dev_adr  jsl   dev_adr                  ;*** Modified above to JSL to GS.OS.DEV
2223 D8F8
2224 D8F8              ; Set direct reg to GS/OS direct page for calls to SCM and device dispatcher
2225 D8F8
2226 D8F8 F4 00 BD              pea   direct_base              ;setup gsos direct page
2227 D8FB 2B                    pld   
2228 D8FC
2229 D8FC              ; Initialize SCM
2230 D8FC
2231 D8FC 22 08 D4 00           jsl   >init_scm
2232 D900 90 03                 bcc   scm_ok
2233 D902 4C BC DF     local_gs_fatal jmp   gsos_fatal_err     ;fatal error - no return
2234 D905              scm_ok    
2235 D905
2236 D905              ; Initialize the device dispatcher
2237 D905
2238 D905 64 00                 stz   <drvr_dev_num            ;device number = dispatcher
2239 D907 64 02                 stz   <drvr_call_num           ;call number = boot init
2240 D909 AD 91 D6              lda   |e1_mslot                ;get boot slot #
2241 D90C 29 07 00              and   #$0007                   ;mask off bits which must be 0
2242 D90F 85 04                 sta   <boot_slot               ;boot slot #
2243 D911 AD EF D6              lda   |e1_drvr_address         ;load address of custom boot driver if
2244 D914 85 20                 sta   <drvr_dib_ptr            ;one was requested, else nil
2245 D916 AD F1 D6              lda   |e1_drvr_address+2
2246 D919 85 22                 sta   <drvr_dib_ptr+2
2247 D91B AD 75 D6              lda   |e1_drvr_id              ;user ID of custom boot driver if one
2248 D91E 85 6A                 sta   <boot_user_id            ;was requested, else 0
2249 D920 22 00 FC 01           jsl   >dev_dispatcher          ;initialize the device dispatcher
2250 D924 B0 DC                 bcs   local_gs_fatal
2251 D926
2252 D926              ; Indicate that GS/OS is now up and running so that the report_fatal routine can
2253 D926              ; attempt to shutdown GS/OS if a fatal error occurs.
2254 D926
2255 D926 EE E9 D6              inc   |e1_gsos_ok
2256 D929
2257 D929              ; Update e1_current_os since we have now switched to GS/OS.
2258 D929
2259 D929 9C 81 D6              stz   |e1_current_os
2260 D92C
2261 D92C              ; Restore the slot 3 rom status (internal vs external) since the ProDOS 8
2262 D92C              ; loader enabled the internal slot 3 rom.
2263 D92C
2264 D92C E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
2265 D92E AD 93 D6              lda   |e1_c3_status            ;get the slot 3 rom status
2266 D931 10 04                 bpl   no_change                ;internal rom was in so no change
2267 D933 8F 0B C0 00           sta   >setslotc3rom            ;map in the external slot rom
2268 D937              no_change  
2269 D937 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
2270 D939
2271 D939              ; Tell the Slot Arbiter to restore the slot 3 screenholes since the ProDOS 8 loader
2272 D939              ; enabled the internal slot 3 rom.  Do NOT check for errors on this call.
2273 D939
2274 D939 AE 95 D6              ldx   |e1_besc                 ;get the "bit encoded slot configuration"
2275 D93C A9 00 03              lda   #$0300                   ;slot 3
2276 D93F 22 BC FC 01           jsl   >dyn_slot_arbiter
2277 D943
2278 D943              ; Set prefix 0 to whatever P8's prefix was.
2279 D943
2280 D943 22 A8 00 E1           _setprefix e1_setpfx0_parms 
2281 D94D B0 B3                 bcs   local_gs_fatal
2282 D94F
2283 D94F              ; Set the library prefix to its default: '/*/system/libs'.
2284 D94F              ; This only gets done when the last OS was ProDOS 8, since it might
2285 D94F              ; have been changed to a different (and valid) value in GS/OS land.
2286 D94F
2287 D94F 22 A8 00 E1           _setprefix1 e1_setpfx2_parms1 
2288 D959 B0 A7        bcs_gs_fatal bcs   local_gs_fatal
2289 D95B
2290 D95B              ; Notify the OS event queue that we have just switched to GS/OS.
2291 D95B              ; The Direct register must be set to GS/OS direct page for the call to SCM.
2292 D95B
2293 D95B 48                    pha                            ; push 3 words of garbage
2294 D95C 48                    pha   
2295 D95D 48                    pha   
2296 D95E A9 04 00              lda   #switch_to_gsos          ;lo word of the event code
2297 D961 A2 00 00              ldx   #>switch_to_gsos         ;hi word of the event code
2298 D964 22 00 B3 00           jsl   >os_event                ;call SCM
2299 D968
2300 D968              ; Check to see if we have the ID of the program we are launching.
2301 D968              ; If not, we have to convert the pathname string to class 1.
2302 D968
2303 D968 AD 7B D6              lda   |e1_open_id              ; do we have an ID?
2304 D96B D0 2B                 bne   have_id                  ; yes
2305 D96D
2306 D96D              ; We are currently using class 0 strings so convert them to class 1 strings...
2307 D96D
2308 D96D              ; First, check to see if we're relaunching the start program.
2309 D96D              ; If so, change e1_path_ptr to point to the start program's class 1 pathname.
2310 D96D
2311 D96D AD 87 D6              lda   |e1_start_flag           ;are we relaunching the start prog?
2312 D970 F0 0E                 beq   not_start                ;no
2313 D972
2314 D972 A9 A1 D7              lda   #e1_start_prog1          ;yes - so get pointer to class 1 string
2315 D975 8D 6F D6              sta   |e1_path_ptr
2316 D978 A9 E1 00              lda   #e1_start_prog1>>16
2317 D97B 8D 71 D6              sta   |e1_path_ptr+2
2318 D97E 80 18                 bra   convert_done
2319 D980              not_start  
2320 D980
2321 D980              ; The Quit call specified the pathname of a program to link to.
2322 D980              ; Convert the class 0 string to a class 1 string.
2323 D980
2324 D980 AE 71 D6              ldx   |e1_path_ptr+2           ;push ptr to source string (class 0)
2325 D983 DA                    phx   
2326 D984 AC 6F D6              ldy   |e1_path_ptr
2327 D987 5A                    phy   
2328 D988 DA                    phx                            ;push ptr to dest string (class 1)
2329 D989 5A                    phy   
2330 D98A 22 74 FC 01           jsl   >cvt_0to1                ;convert class 0 string to class 1
2331 D98E
2332 D98E              ; Now, convert the class 0 separators (/) to class 1 separators (:).
2333 D98E
2334 D98E AC 71 D6              ldy   |e1_path_ptr+2           ;get pointer to string in X and Y
2335 D991 AE 6F D6              ldx   |e1_path_ptr
2336 D994 22 4C D3 E1           jsl   slash_2_colon            ;replace slashes with colons
2337 D998
2338 D998              convert_done  
2339 D998
2340 D998              have_id   
2341 D998
2342 D998              ; fall into next section
2343 D998
2344 D998              ;-------------------------------------------------------------------------------
2345 D998
2346 D998              its_gsos  
2347 D998                       Import force_get_info
2348 D998
2349 D998              ; Set OS_Kind to $01 to indicate that GS/OS is running
2350 D998
2351 D998                       longa off
2352 D998                       longi off
2353 D998 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
2354 D99A
2355 D99A A9 01                 lda   #$01
2356 D99C 8D BC 00              sta   |OS_Kind
2357 D99F
2358 D99F C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
2359 D9A1                       longa on
2360 D9A1                       longi on
2361 D9A1
2362 D9A1              ; Make sure cache will be purged if system runs out of memory
2363 D9A1
2364 D9A1 22 14 A9 00           jsl   >cache_in_queue
2365 D9A5
2366 D9A5              ; Make sure that the .CONSOLE device exists before launching the application
2367 D9A5
2368 D9A5 A9 1D D9              lda   #e1_cons_path            ;set up the pathname ptr parameter
2369 D9A8 8D 2F D6              sta   |e1_gdn_ptr              ;for the call
2370 D9AB A9 E1 00              lda   #e1_cons_path>>16
2371 D9AE 8D 31 D6              sta   |e1_gdn_ptr+2
2372 D9B1 22 A8 00 E1           _getdevnumber1 e1_gdn_parms1   ;class 1 call
2373 D9BB B0 9C                 bcs   bcs_gs_fatal
2374 D9BD
2375 D9BD              ; Set prefixes 1 and 9 to the application's pathname.
2376 D9BD              ; Set prefix 33 to the application's USER folder.
2377 D9BD              ; Set prefixes 10,11,12 to '.CONSOLE'.
2378 D9BD
2379 D9BD              try_again  
2380 D9BD 20 26 DB              jsr   set_prefixes
2381 D9C0 B0 97                 bcs   bcs_gs_fatal
2382 D9C2
2383 D9C2              ; If we have an ID at this point, it was pulled off the ID stack so restart
2384 D9C2              ; the application.
2385 D9C2
2386 D9C2 AD 7B D6              lda   |e1_open_id              ; do we have an ID?
2387 D9C5 D0 2F                 bne   restart_it               ; yes - so do a restart call
2388 D9C7
2389 D9C7              ; We have a pathname but not an ID so check to see if the application has been
2390 D9C7              ; previously run. If it has, then maybe we can use the ID for a restart call.
2391 D9C7
2392 D9C7 48                    pha                            ; Push space for output user ID.
2393 D9C8 AD 71 D6              lda   |e1_path_ptr+2           ; push ptr to pathname
2394 D9CB 48                    pha   
2395 D9CC AD 6F D6              lda   |e1_path_ptr
2396 D9CF 48                    pha   
2397 D9D0 A2 11 21 22           _getuserid2 
2398 D9D7 68                    pla                            ; Pull off output user ID
2399 D9D8 B0 30                 bcs   unknown_app              ; loader has no record of this app
2400 D9DA 8D 7B D6              sta   |e1_open_id              ; save ID for the Restart call
2401 D9DD
2402 D9DD              ; We found an ID for the app so check to see if it's currently on the ID stack.
2403 D9DD              ; If so, force an InitialLoad since we don't want to relaunch an app which
2404 D9DD              ; is sitting on the ID stack.
2405 D9DD
2406 D9DD 20 73 DF              jsr   check_id_stack           ; is the ID on the stack?
2407 D9E0 B0 6B                 bcs   init_load                ; yes - so force an InitialLoad
2408 D9E2
2409 D9E2 20 C9 DD              jsr   force_get_info           ; get the file info
2410 D9E5 AD 85 D6              lda   |e1_aux_type             ; check the aux type
2411 D9E8 29 02 FF              and   #$FF02                   ; check for signature byte and desktop bit
2412 D9EB C9 02 DB              cmp   #$DB02
2413 D9EE D0 06                 bne   restart_it               ; not a desktop app, leave e1_open_id as-is
2414 D9F0 A9 00 80              lda   #$8000                   ; else set bit 15
2415 D9F3 0C 7B D6              tsb   |e1_open_id
2416 D9F6
2417 D9F6              ; Restart the application from memory.
2418 D9F6
2419 D9F6              restart_it  
2420 D9F6 48                    pha                            ; Push 10 bytes for result space
2421 D9F7 48                    pha                            ; for Restart call.
2422 D9F8 48                    pha   
2423 D9F9 48                    pha   
2424 D9FA 48                    pha   
2425 D9FB AD 7B D6              lda   |e1_open_id
2426 D9FE 0A                    asl   a                        ; clear our SHR bit
2427 D9FF 4A                    lsr   a
2428 DA00 48                    pha                            ; Push user ID on stack.
2429 DA01 A2 11 0A 22           _restart                       ; Restart the Application.
2430 DA08 80 6E                 bra   get_outputs              ; Outputs are the same as for InitLoad.
2431 DA0A
2432 DA0A
2433 DA0A              ; The loader has no record of the app so check its partial path length.
2434 DA0A              ; If the length is > 64 characters then check the auxtype of the app
2435 DA0A              ; to see if it's "GS/OS aware" (ie - uses prefixes 8 and above).
2436 DA0A              ; If not, put up a warning message since the app may not be able to run
2437 DA0A              ; correctly since prefixes 0-7 are limited to 64 characters.
2438 DA0A
2439 DA0A              unknown_app  
2440 DA0A AD 73 D6              lda   |e1_path_len             ;get length of app's partial path
2441 DA0D C9 41 00              cmp   #p8_max_length+1         ;is the string > 64 chars?
2442 DA10 90 3B                 bcc   path_len_ok              ;no - so it's OK
2443 DA12 AD 85 D6              lda   |e1_aux_type             ;yes - so get the app's auxtype
2444 DA15 29 01 FF              and   #gsos_aware_mask         ;mask off certain bits
2445 DA18 C9 01 DB              cmp   #gsos_aware              ;is the app "GS/OS aware"?
2446 DA1B F0 30                 beq   path_len_ok              ;yes - so no need for a warning
2447 DA1D
2448 DA1D AD 7F D6              lda   |e1_quit_flags           ;was previous app put on ID stack?
2449 DA20 10 25                 bpl   no_pop_back              ;no - so put up different message
2450 DA22
2451 DA22 A2 35 00              ldx   #aware_err1              ;message #
2452 DA25 20 8A DF              jsr   gsos_nonfatal            ;put up non-fatal error message
2453 DA28 6A                    ror   a                        ;2='Cancel' selected, 1='Continue' selected
2454 DA29 B0 22                 bcs   path_len_ok
2455 DA2B              rtn_to_previous  
2456 DA2B
2457 DA2B              ; before returning to the launching app, clear the fake menu bar on the SHR screen
2458 DA2B              ; but only if the SHR screen is currently being displayed
2459 DA2B
2460 DA2B AD 29 C0              lda   newvideo                 ;read NewVideo byte
2461 DA2E 29 80 00              and   #$0080                   ;SHR displayed?
2462 DA31 F0 0E                 beq   @no_blast                ;no, don't touch screen
2463 DA33
2464 DA33 A9 FF FF              lda   #$FFFF                   ;clear with white pixels
2465 DA36 A2 E0 06              ldx   #11*160                  ;11 scan lines * 160 bytes per scan line
2466 DA39              @1        
2467 DA39 CA                    dex   
2468 DA3A CA                    dex   
2469 DA3B 9F A0 20 E1           sta   >$E120A0,x               ;leave black line at top and bottom of menu bar
2470 DA3F D0 F8                 bne   @1                       ;loop until done
2471 DA41
2472 DA41              @no_blast  
2473 DA41 20 40 D3              jsr   get_next_prog            ;get ID of next application to launch
2474 DA44 4C BD D9              jmp   try_again                ;and relaunch it
2475 DA47
2476 DA47              no_pop_back                             ;can't relaunch previous app
2477 DA47 A2 36 00              ldx   #aware_err2              ;message #
2478 DA4A 20 8A DF              jsr   gsos_nonfatal            ;put up non-fatal error message
2479 DA4D
2480 DA4D              path_len_ok                             ;path length is OK or "Continue" selected
2481 DA4D
2482 DA4D              ; Load the application from disk.
2483 DA4D              ; First, try loading the app in non-special memory.  If that fails, then
2484 DA4D              ; try loading the app in special memory.
2485 DA4D
2486 DA4D              init_load  
2487 DA4D A9 01 00              lda   #1                       ; initialize flag to indicate that special
2488 DA50 8D 53 D6              sta   |e1_word_temp            ; memory cannot be used
2489 DA53 48                    pha                            ; push 10 bytes for result space
2490 DA54 48                    pha                            ; for Initial Load call
2491 DA55 48                    pha   
2492 DA56 48                    pha   
2493 DA57 48                    pha   
2494 DA58 F4 00 00     retry_load pea   0                      ; assume we need to get a new User ID
2495 DA5B AD 71 D6              lda   |e1_path_ptr+2           ; push ptr to pathname
2496 DA5E 48                    pha   
2497 DA5F AD 6F D6              lda   |e1_path_ptr
2498 DA62 48                    pha   
2499 DA63 AD 53 D6              lda   |e1_word_temp
2500 DA66 48                    pha                            ; indicate whether special memory can be used
2501 DA67 F4 01 00              pea   1                        ; indicate that pathname is class 1
2502 DA6A A2 11 20 22           _initialload2                  ; load the application
2503 DA71 90 05                 bcc   get_outputs              ; the app was loaded without error
2504 DA73 CE 53 D6              dec   |e1_word_temp            ; got an error - was special mem allowed?
2505 DA76 F0 E0                 beq   retry_load               ; no-so retry the load but allow special mem
2506 DA78
2507 DA78              ; Get the outputs from the Restart call or the InitialLoad call
2508 DA78
2509 DA78              get_outputs  
2510 DA78 AA                    tax                            ; save error code
2511 DA79 68                    pla                            ; Pull user id
2512 DA7A 8D 77 D6              sta   |e1_user_id
2513 DA7D 68                    pla                            ; Pull lo word of program start address
2514 DA7E 8F 22 DB E0           sta   >goadr
2515 DA82 68                    pla                            ; Pull hi word of program start address
2516 DA83 8F 24 DB E0           sta   >goadr+2
2517 DA87 68                    pla                            ; Pull zero page buffer address
2518 DA88 8D 9B D6              sta   |e1_zp_start
2519 DA8B 68                    pla                            ; Pull zero page buffer size
2520 DA8C 8D 9D D6              sta   |e1_zp_size
2521 DA8F 90 07                 bcc   ok
2522 DA91 8A           bad_adr  txa                            ; restore error code
2523 DA92 20 9D DF              jsr   gsos_nonfatal2           ; display dialog
2524 DA95 4C 2B DA              jmp   rtn_to_previous
2525 DA98              ok        
2526 DA98 A2 5C 00              ldx   #not_system_file         ; error code in case goadr is 0
2527 DA9B              ;;; 	lda	>goadr	; is the program start address 0?
2528 DA9B              ;;;	ora	>goadr+2
2529 DA9B              *** optimized 23-Oct-92 DAL -- valid address is never in page zero
2530 DA9B AF 23 DB E0           lda   >goadr+1
2531 DA9F              *** end 23-Oct-92
2532 DA9F F0 F0                 beq   bad_adr                  ; yes - so report error
2533 DAA1
2534 DAA1              ; If we got here from a P16 Quit call which specified a pathname, we must now
2535 DAA1              ; deallocate the space we obtained for the copy of the pathname
2536 DAA1              ; since we are done using it.
2537 DAA1
2538 DAA1 22 1B D5 E1           jsl   dispose_path
2539 DAA5 90 03                 bcc   path_disposed
2540 DAA7 4C BC DF     local_gs_fatal2 jmp   gsos_fatal_err    ;fatal error - no return
2541 DAAA              path_disposed  
2542 DAAA
2543 DAAA              ; Tell SCM to not put up the 'mount volume' dialog automatically
2544 DAAA AF F6 B9 00           lda   >sys_prefs               ;get preferences flag
2545 DAAE 0A                    asl   a                        ;clear bit 15
2546 DAAF 4A                    lsr   a
2547 DAB0 8F F6 B9 00           sta   >sys_prefs
2548 DAB4
2549 DAB4              ; Now, initialize the text tools and ignore all errors
2550 DAB4
2551 DAB4 22 E6 D3 E1           jsl   Init_text_tools
2552 DAB8
2553 DAB8              ; Call the first routine in the auto linked chain of routines that
2554 DAB8              ; need to know when the OS is going to be changed.
2555 DAB8
2556 DAB8 22 AC 00 E1           jsl   >OS_Switch               ; Notify the routines.
2557 DABC
2558 DABC              ; Now setup the user's direct register and stack pointer
2559 DABC
2560 DABC 22 E8 DE E0           jsl   alloc_user_zp
2561 DAC0 B0 E5                 bcs   local_gs_fatal2
2562 DAC2 1B                    tcs                            ; set user's stack pointer
2563 DAC3
2564 DAC3              ; make sure the text screen is displayed for those apps that are not
2565 DAC3              ; "Desktop Aware"
2566 DAC3
2567 DAC3 F4 00 00              pea   $0000                    ; space for result
2568 DAC6 A2 04 06              ldx   #$0604                   ; QDStatus
2569 DAC9 22 00 00 E1           jsl   $E10000
2570 DACD 68                    pla                            ; retrieve result
2571 DACE D0 20                 bne   @show_shr                ; QD is active, just leave the screen as-is
2572 DAD0
2573 DAD0 AD 7B D6              lda   |e1_open_id              ; do we need to turn off the SHR screen?
2574 DAD3 30 1B                 bmi   @show_shr                ; no, this app is a desktop app
2575 DAD5 D0 0B                 bne   @show_text               ; yes, doesn't say it supports desktop
2576 DAD7              @check_aux  
2577 DAD7 AD 85 D6              lda   |e1_aux_type             ; check the aux type of the file
2578 DADA 29 02 FF              and   #$FF02                   ; check signature byte and destop app bit
2579 DADD C9 02 DB              cmp   #$DB02                   ; is it a desktop app?
2580 DAE0 F0 0E                 beq   @show_shr                ; yup, leave SHR enabled
2581 DAE2              @show_text  
2582 DAE2 E2 20                 sep   #$20                     ; 8-bit accumulator
2583 DAE4                       longa off
2584 DAE4 AF 29 C0 E0           lda   >$E0C029                 ; get the newVideo byte
2585 DAE8 29 7F                 and   #%01111111               ; clear the SHR bit
2586 DAEA 8F 29 C0 E0           sta   >$E0C029                 ; then turn the text screen on
2587 DAEE C2 20                 rep   #$20                     ; back to 16-bit accumulator
2588 DAF0                       longa on
2589 DAF0              @show_shr  
2590 DAF0
2591 DAF0              ; Decrement the system busy flag
2592 DAF0
2593 DAF0 22 68 00 E1           jsl   >decbusyflg
2594 DAF4
2595 DAF4              ; Now, move the code which will launch the app onto the application's stack
2596 DAF4
2597 DAF4                       longa off
2598 DAF4                       longi off
2599 DAF4 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
2600 DAF6
2601 DAF6 A2 08                 ldx   #go_end-go               ; # of bytes to move to user's stack.
2602 DAF8 BF 1C DB E0  loop     lda   >go-1,x                  ; Get the byte to move.
2603 DAFC 48                    pha                            ; Push it onto app's stack.
2604 DAFD CA                    dex                            ; Next byte of code to move.
2605 DAFE D0 F8                 bne   loop
2606 DB00
2607 DB00                       longa on
2608 DB00                       longi on
2609 DB00 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
2610 DB02
2611 DB02              ; The stack pointer now points just below the code we moved onto the stack.
2612 DB02              ; We must disable interrupts since we are going to mess with the stack pointer
2613 DB02              ; and if an interrupt occurs, the code we just moved onto the stack will be
2614 DB02              ; trashed. Interrupts will be re-enabled by the RTI.
2615 DB02
2616 DB02 78                    sei   
2617 DB03
2618 DB03 3B                    tsc                            ; Put S in A for use as part of JMP
2619 DB04 1A                    inc   a                        ; Adjust A to point to code on stack
2620 DB05 8F 1A DB E0           sta   >stack_adr               ; Store lo word of code addr after JMP
2621 DB09 1A                    inc   a                        ; Now set S to point to 1 below the RTI stuff
2622 DB0A 1A                    inc   a                        ; so when RTI is executed, we will jmp off to
2623 DB0B 1A                    inc   a                        ; the application in 16 bit mode/interrupts on
2624 DB0C 1B                    tcs                            ; Stack now ready for the RTI.
2625 DB0D
2626 DB0D AD 77 D6              lda   |e1_user_id              ; User gets his id from A reg.
2627 DB10 8D 79 D6              sta   |e1_current_id           ; Update e1_current_id so can later shutdown app.
2628 DB13 A2 00 00              ldx   #$0000                   ; Set X and Y to zero to denote the application
2629 DB16 9B                    txy                            ; is not being run from a shell program
2630 DB17
2631 DB17              ; Jump to the code on the stack which will then do an RTI to launch the app
2632 DB17
2633 DB17                       longa off
2634 DB17                       longi off
2635 DB17 E2 30                 sep   #$30                     ; Must be 8 bit to jmp to code on stack!
2636 DB19
2637 DB19 5C                    DC B:$5c                       ; Jump long opcode to jump to stack code
2638 DB1A F8 17        stack_adr DS B:2                        ; Low 2 bytes of the stack code's entry address
2639 DB1C 00                    DC B:0                         ; High byte of address is zero for stack.
2640 DB1D
2641 DB1D              ;-------------------------------------------------------------------------------
2642 DB1D              ; code which is moved onto the stack
2643 DB1D
2644 DB1D              go        
2645 DB1D CD 81 C0              DC B:$cd,$81,$c0               ; cmp $c081 to enable the ROM
2646 DB20 40                    DC B:$40                       ; RTI opcode to jmp to the application.
2647 DB21 00                    DC B:$00                       ; Will be value of P for application.
2648 DB22 00 00 05     goadr    DS B:3                         ; Will contain starting address of app
2649 DB25              go_end    
2650 DB25 00                    DS B:1                         ; Space for unused fourth byte of above adr.
2651 DB26
2652 DB26                       DataChk on
2653 DB26                       ENDP 
2654 DB26
2655 DB26
2656 DB26
2657 DB26                       eject 
2658 DB26              ;===============================================================================
2659 DB26              ; set_prefixes
2660 DB26              ;
2661 DB26              ; Entry is in 16-bit native mode.
2662 DB26              ; Exit is in 16-bit native mode.
2663 DB26              ; Data bank register is set to bank $E1 on entry and exit.
2664 DB26              ; Direct register is set to GS/OS direct page at $00BD00 on entry and exit.
2665 DB26              ; Stack pointer is set to GQuit's stack on entry and exit.
2666 DB26              ;
2667 DB26              ; Inputs:       none
2668 DB26              ;
2669 DB26              ; Outputs:      c - 0 if no error ; 1 if error.
2670 DB26              ;               A - error code if c=1
2671 DB26              ;               e1_path_len - length of (pathname-filename)
2672 DB26              ;
2673 DB26              ; Notes:        The parameter block for the DInfo call must not be in our $E0 or
2674 DB26              ;               $E1 language card space since the Device Dispatcher will switch in
2675 DB26              ;               bank 1 of the language cards thereby switching out the parameter
2676 DB26              ;               block.  So, by setting the Direct register to the bottom of
2677 DB26              ;               GQuit's stack space we can use the area starting at $00/BB00 for
2678 DB26              ;               the parameter block and the device name buffer as well as other
2679 DB26              ;               temporary variables.
2680 DB26              ;
2681 DB26              ; This routine sets prefixes 1 and 9 to the application's partial pathname (the
2682 DB26              ; full pathname to the application but with the filename removed).  If the
2683 DB26              ; partial pathname is longer than 64 characters, then prefix 1 is set to
2684 DB26              ; a null string.  If the AppleShare FST has not been loaded into the system, then
2685 DB26              ; prefix 33 (@) is also set to the app's partial pathname.  If the AppleShare FST
2686 DB26              ; has been loaded into the system, then this routine will check to see if the
2687 DB26              ; application being launched resides on an AppleShare volume.  If so, the
2688 DB26              ; routine will then ask the AppleShare FST for the correct pathname to use when
2689 DB26              ; setting prefix 33.  Otherwise, prefix 33 will be set to the partial pathname.
2690 DB26              ; If the 'skip_std' bit of the Quit Flags is clear then prefixes 10, 11 and 12
2691 DB26              ; will be set to '.CONSOLE'.  If the 'skip_std' bit is set to 1,
2692 DB26              ; then prefixes 10, 11 and 12 will not be changed.
2693 DB26              ;===============================================================================
2694 DB26
2695 DB26              set_prefixes PROC 
2696 DB26                       DataChk off
2697 DB26
2698 DB26              ; Direct page equates
2699 DB26
2700 DB26              path_ptr equ   0                        ;ptr to application's pathname
2701 DB26              fullpath_len equ   4                    ;length of application's full pathname
2702 DB26              partialpath_len equ   6                 ;length of application's partial pathname
2703 DB26                                                      ;DInfo - class 1 parameter list
2704 DB26              dinfo_pcount equ   8                      ;parameter count
2705 DB26              dinfo_dnum equ   10                       ;device number
2706 DB26              dinfo_ptr equ   12                        ;ptr to output buffer for device name
2707 DB26                                                      ;class 1 output buffer for device name
2708 DB26              header   equ   16                         ;header (2 bytes)
2709 DB26              buffer   equ   18                         ;buffer (33 bytes)
2710 DB26
2711 DB26              ; Address equates
2712 DB26
2713 DB26              dinfo_parms1 equ   gquit_stack_end+dinfo_pcount ;address of DInfo parameter list
2714 DB26              header_adr equ   gquit_stack_end+header ;address of output buffer header
2715 DB26              buffer_adr equ   gquit_stack_end+buffer ;address of output buffer
2716 DB26
2717 DB26              ; Misc. equates
2718 DB26
2719 DB26              header_value equ   35                   ;size of output buffer + header
2720 DB26
2721 DB26
2722 DB26                       longa on
2723 DB26                       longi on
2724 DB26
2725 DB26              ; Set the direct register to the bottom of GQuit's stack space
2726 DB26
2727 DB26 0B                    phd                            ;save original direct register
2728 DB27 A9 00 BB              lda   #gquit_stack_end
2729 DB2A 5B                    tcd   
2730 DB2B
2731 DB2B              ; Check the 'skip_std' bit of the Quit Flags.
2732 DB2B              ; If it's clear, then set prefixes 10, 11 and 12 to '.CONSOLE'.
2733 DB2B              ; If it's set, then don't set prefixes 10, 11 and 12.
2734 DB2B
2735 DB2B AD 7F D6              lda   |e1_quit_flags
2736 DB2E 29 00 20              and   #skip_std_bit
2737 DB31 D0 20                 bne   skip_std_prefixes
2738 DB33
2739 DB33 A9 1D D9              lda   #e1_cons_path
2740 DB36 8D 9F D5              sta   |e1_setpfx_ptr           ;set the ptr parameter for the SetPrefix call
2741 DB39 A9 E1 00              lda   #e1_cons_path>>16
2742 DB3C 8D A1 D5              sta   |e1_setpfx_ptr+2
2743 DB3F
2744 DB3F A2 03 00              ldx   #3                       ;we have to set 3 prefixes
2745 DB42 A9 0A 00              lda   #10
2746 DB45 8D 9D D5              sta   |e1_setpfx_num           ;prefix # to set
2747 DB48
2748 DB48              setpfx_loop  
2749 DB48              ;;;	_setprefix1 e1_setpfx_parms1	;class 1 call
2750 DB48 20 8D DC              jsr   SetPrefix1_e1_setpfx_parms1 ;opt 23-Oct-92 DAL
2751 DB4B B0 76                 bcs   bcs_done2
2752 DB4D EE 9D D5              inc   |e1_setpfx_num
2753 DB50 CA                    dex   
2754 DB51 D0 F5                 bne   setpfx_loop
2755 DB53
2756 DB53              skip_std_prefixes  
2757 DB53
2758 DB53              ; Copy the ptr to the application's full pathname onto direct page.
2759 DB53              ; If we only have the app's ID, get its pathname from the loader.
2760 DB53
2761 DB53 AE 6F D6              ldx   |e1_path_ptr             ; put ptr to app's pathname in X,Y
2762 DB56 AC 71 D6              ldy   |e1_path_ptr+2
2763 DB59 AD 7B D6              lda   |e1_open_id              ; if we have an ID, we don't know the
2764 DB5C F0 13                 beq   got_pathname             ; app's pathname so get it from the loader
2765 DB5E
2766 DB5E 48                    pha                            ; push space for output pathname pointer
2767 DB5F 48                    pha   
2768 DB60 0A                    asl   a                        ; clear our SHR bit
2769 DB61 4A                    lsr   a
2770 DB62 48                    pha                            ; push app's ID
2771 DB63 F4 01 00              pea   1                        ; input file number
2772 DB66 A2 11 22 22           _lgetpathname2                 ; get the pathname from the loader
2773 DB6D FA                    plx                            ; put ptr to app's pathname in X,Y
2774 DB6E 7A                    ply   
2775 DB6F B0 52                 bcs   bcs_done2
2776 DB71              got_pathname  
2777 DB71 86 00                 stx   <path_ptr                ; store pathname ptr on direct page
2778 DB73 84 02                 sty   <path_ptr+2
2779 DB75
2780 DB75              ; Strip off the filename so that we are left with a partial pathname.
2781 DB75              ; Also, save the application's filename in e1_app_filename for SCM to use.
2782 DB75
2783 DB75 A7 00                 lda   [<path_ptr]              ; Get length of app's full pathname
2784 DB77 85 04                 sta   <fullpath_len            ; and save so we can restore it later
2785 DB79 A8                    tay                            ; put in Y for use as index
2786 DB7A C8                    iny   
2787 DB7B              *** G. Branche
2788 DB7B              ; Check for a trailing separator first.  If found, simply decrement the
2789 DB7B              ; length so that it's not a part of the pathname any longer
2790 DB7B
2791 DB7B B7 00                 lda   [<path_ptr],y            ; get last character in pathname
2792 DB7D 29 FF 00              and   #$00FF
2793 DB80 C9 3A 00              cmp   #':'                     ; trailing colon?
2794 DB83 D0 07                 bne   @no_trailer              ; no...
2795 DB85 88                    dey                            ; else decrement length to remove it
2796 DB86 98                    tya   
2797 DB87 3A                    dec   a                        ; one more time (for iny above)
2798 DB88 87 00                 sta   [<path_ptr]              ; reset the length
2799 DB8A 85 04                 sta   <fullpath_len
2800 DB8C              @no_trailer  
2801 DB8C              *** end change
2802 DB8C A2 00 00              ldx   #0                       ; counter for filename length
2803 DB8F
2804 DB8F                       longa off
2805 DB8F                       longi off
2806 DB8F E2 20                 sep   #$20                     ;***** begin 8-bit m mode *****
2807 DB91
2808 DB91 B7 00        char_loop lda   [<path_ptr],y           ; Now strip off the file name to yield
2809 DB93 88                    dey                            ; the partial path to the application
2810 DB94 E8                    inx                            ; Determine filename length at same time
2811 DB95 C9 3A                 cmp   #':'                     ; Class 1 string so separator is colon
2812 DB97 D0 F8                 bne   char_loop                ; Check next character
2813 DB99 88                    dey                            ; Subtract 1 for the separator
2814 DB9A CA                    dex                            ; ditto
2815 DB9B
2816 DB9B 5A                    phy                            ;save partial pathname length on stack
2817 DB9C 8E 1A D7              stx   |e1_app_filename         ;store length of filename
2818 DB9F
2819 DB9F A4 04                 ldy   <fullpath_len            ;get back length of full pathname
2820 DBA1 C8                    iny   
2821 DBA2 B7 00        name_loop lda   [<path_ptr],y           ;copy filename into e1_app_filename
2822 DBA4 9D 1A D7              sta   |e1_app_filename,x       ;which is a class 0 string
2823 DBA7 88                    dey   
2824 DBA8 CA                    dex   
2825 DBA9 D0 F7                 bne   name_loop
2826 DBAB
2827 DBAB                       longa on
2828 DBAB                       longi on
2829 DBAB C2 20                 rep   #$20                     ;***** return to 16-bit m mode *****
2830 DBAD
2831 DBAD 68                    pla                            ; retrieve partial pathname length
2832 DBAE 87 00                 sta   [<path_ptr]              ; Update the length word.
2833 DBB0
2834 DBB0              ; Set prefix 9 (the application prefix) to the application's partial pathname.
2835 DBB0
2836 DBB0 A9 09 00              lda   #9
2837 DBB3 8D 9D D5              sta   |e1_setpfx_num
2838 DBB6 A5 00                 lda   <path_ptr                ; Get pathname ptr and store into the
2839 DBB8 8D 9F D5              sta   |e1_setpfx_ptr           ; SetPrefix parameter list
2840 DBBB A5 02                 lda   <path_ptr+2
2841 DBBD 8D A1 D5              sta   |e1_setpfx_ptr+2
2842 DBC0
2843 DBC0              ;;;	_setprefix1 e1_setpfx_parms1	;class 1 call
2844 DBC0 20 8D DC              jsr   SetPrefix1_e1_setpfx_parms1 ;opt 23-Oct-92 DAL
2845 DBC3 B0 54        bcs_done2 bcs   bcs_done
2846 DBC5
2847 DBC5              ; Set prefix 1 (the application prefix) to the application's partial pathname.
2848 DBC5              ; If the partial pathname is longer than 64 chars then set prefix 1 to a null string.
2849 DBC5              ; Save the length of the partial path for later.
2850 DBC5
2851 DBC5 A9 01 00              lda   #1
2852 DBC8 8D 9D D5              sta   |e1_setpfx_num
2853 DBCB A7 00                 lda   [<path_ptr]              ;get length word
2854 DBCD 8D 73 D6              sta   |e1_path_len             ;and save for later
2855 DBD0 C9 41 00              cmp   #p8_max_length+1         ;is the string > 64 chars?
2856 DBD3 90 0C                 bcc   len_ok                   ;no - so OK to set prefix 1
2857 DBD5 A9 6D D8              lda   #e1_null_str             ;get ptr to null string and store in
2858 DBD8 8D 9F D5              sta   |e1_setpfx_ptr           ;the SetPrefix parameter list
2859 DBDB A9 E1 00              lda   #e1_null_str>>16
2860 DBDE 8D A1 D5              sta   |e1_setpfx_ptr+2
2861 DBE1              len_ok    
2862 DBE1              ;;;	_setprefix1 e1_setpfx_parms1	;class 1 call
2863 DBE1 20 8D DC              jsr   SetPrefix1_e1_setpfx_parms1 ;opt 23-Oct-92 DAL
2864 DBE4 B0 33                 bcs   bcs_done
2865 DBE6
2866 DBE6              ; Set prefix 33 (the USER folder prefix)...
2867 DBE6
2868 DBE6              ; First, check to see if the AppleShare FST has been loaded into the system
2869 DBE6
2870 DBE6 AD 8B D6              lda   |e1_appleshare           ;has the AppleShare FST been loaded?
2871 DBE9 D0 03                 bne   got_ashare               ;yes
2872 DBEB 4C 77 DC              jmp   set_to_app               ;no - so set 33 to the app pathname
2873 DBEE              got_ashare  
2874 DBEE
2875 DBEE              ; The AppleShare FST has been loaded into the system so we need to determine if
2876 DBEE              ; the application being launched resides on an AppleShare volume.
2877 DBEE
2878 DBEE              ; Adjust the length word of the application's pathname to only include the
2879 DBEE              ; volume name so we can make a GetDevNumber call
2880 DBEE
2881 DBEE A7 00                 lda   [<path_ptr]              ;get the length word of the partial path
2882 DBF0 85 06                 sta   <partialpath_len         ;and save
2883 DBF2
2884 DBF2 A0 02 00              ldy   #2                       ;skip length word and beginning separator
2885 DBF5 C8           loop     iny   
2886 DBF6 B7 00                 lda   [<path_ptr],y            ;get next char
2887 DBF8 29 FF 00              and   #$00ff                   ;mask off hi byte
2888 DBFB C9 3A 00              cmp   #':'                     ;is it a class 1 separator?
2889 DBFE D0 F5                 bne   loop                     ;no
2890 DC00 88                    dey                            ;adjust length count to not include
2891 DC01 88                    dey                            ;the separator
2892 DC02 98                    tya   
2893 DC03 87 00                 sta   [<path_ptr]              ;and store length of volume name
2894 DC05
2895 DC05              ; Make a GetDevNumber call to translate the volume name into a device number
2896 DC05
2897 DC05 A5 00                 lda   <path_ptr                ;store the volume name ptr into the
2898 DC07 8D 2F D6              sta   |e1_gdn_ptr              ;GetDevNumber parameter list
2899 DC0A A5 02                 lda   <path_ptr+2
2900 DC0C 8D 31 D6              sta   |e1_gdn_ptr+2
2901 DC0F 22 A8 00 E1           _getdevnumber1 e1_gdn_parms1   ;class 1 call
2902 DC19 B0 70        bcs_done bcs   done
2903 DC1B
2904 DC1B              ; Restore the length word of the application's partial pathname
2905 DC1B
2906 DC1B A5 06                 lda   <partialpath_len
2907 DC1D 87 00                 sta   [<path_ptr]
2908 DC1F
2909 DC1F              ; Make a DInfo call to translate the device number into a device name
2910 DC1F
2911 DC1F A9 02 00              lda   #2
2912 DC22 85 08                 sta   <dinfo_pcount            ;set the pcount parameter for the DInfo call
2913 DC24 AD 33 D6              lda   |e1_gdn_dnum
2914 DC27 85 0A                 sta   <dinfo_dnum              ;set the device # param for the Dinfo call
2915 DC29 A9 10 BB              lda   #header_adr
2916 DC2C 85 0C                 sta   <dinfo_ptr               ;set the ptr parameter for the Dinfo call
2917 DC2E 64 0E                 stz   <dinfo_ptr+2
2918 DC30 A9 23 00              lda   #header_value            ;initialize the size header for the output
2919 DC33 85 10                 sta   <header                  ;buffer (max devname length is 31 chars)
2920 DC35 22 A8 00 E1           _dinfo1 dinfo_parms1           ;class 1 call
2921 DC3F B0 4A                 bcs   done
2922 DC41
2923 DC41              ; Now make a Volume call to determine which file system resides on the volume
2924 DC41
2925 DC41 A9 12 BB              lda   #buffer_adr
2926 DC44 8D 37 D6              sta   |e1_volume_ptr           ;set the ptr parameter for the Volume call
2927 DC47 22 A8 00 E1           _volume1 e1_volume_parms1      ;class 1 call
2928 DC51 90 08                 bcc   ok
2929 DC53 C9 4F 00              cmp   #buff_too_small          ;did we get a "buffer too small" error?
2930 DC56 F0 03                 beq   ok                       ;yes - so ignore it
2931 DC58 38                    sec                            ;no - so indicate a real error
2932 DC59 80 30                 bra   done
2933 DC5B              ok        
2934 DC5B
2935 DC5B              ; Check if the file system on the volume is AppleShare.
2936 DC5B
2937 DC5B AD 47 D6              lda   |e1_volume_id            ;get the file system ID
2938 DC5E C9 0D 00              cmp   #appleshare_ID           ;is it AppleShare?
2939 DC61 D0 14                 bne   set_to_app               ;no - so set 33 to the app pathname
2940 DC63
2941 DC63              ; The application is being launched from an AppleShare volume so ask the
2942 DC63              ; AppleShare FST for the correct path to use when setting prefix 33.
2943 DC63              ; If we get an error back, set prefix 33 to the application's partial pathname.
2944 DC63
2945 DC63 22 A8 00 E1           _fstspecific1 e1_fst_parms1    ;class 1 call
2946 DC6D B0 08                 bcs   set_to_app               ;non-fatal error
2947 DC6F AD 4F D6              lda   |e1_fst_ptr              ;lo word of pathname ptr
2948 DC72 AE 51 D6              ldx   |e1_fst_ptr+2            ;hi word of pathname ptr
2949 DC75 80 04                 bra   set_it
2950 DC77
2951 DC77              ; Set prefix 33 to the application's partial pathname.
2952 DC77
2953 DC77              set_to_app  
2954 DC77 A5 00                 lda   <path_ptr                ;lo word of pathname ptr
2955 DC79 A6 02                 ldx   <path_ptr+2              ;hi word of pathname ptr
2956 DC7B
2957 DC7B              ; Set prefix 33
2958 DC7B
2959 DC7B              set_it    
2960 DC7B 0B                    phd                            ;save direct register
2961 DC7C F4 00 BD              pea   direct_base              ;setup gsos direct page for call to SCM
2962 DC7F 2B                    pld   
2963 DC80 22 D6 B3 00           jsl   set_prefix_33            ;set prefix 33
2964 DC84 2B                    pld                            ;restore direct register
2965 DC85 B0 04                 bcs   done
2966 DC87
2967 DC87              ; Restore the original length word of the application's pathname
2968 DC87
2969 DC87 A5 04                 lda   <fullpath_len
2970 DC89 87 00                 sta   [<path_ptr]
2971 DC8B
2972 DC8B 2B           done     pld                            ;restore original direct register
2973 DC8C 60                    rts   
2974 DC8D
2975 DC8D              *** Subrootinized 23-Oct-92 DAL (3 calls; replaces 30 bytes w/ 20, saving 10)
2976 DC8D              SetPrefix1_e1_setpfx_parms1  
2977 DC8D 22 A8 00 E1           _SetPrefix1 e1_setpfx_parms1   ;class 1 call
2978 DC97 60                    rts   
2979 DC98              *** end of subroutine
2980 DC98
2981 DC98                       DataChk on
2982 DC98                       ENDP 
2983 DC98
2984 DC98                       eject 
2985 DC98              ;==============================================================================
2986 DC98              ; get_info_sub
2987 DC98              ;
2988 DC98              ; Entry is in 16-bit native mode.
2989 DC98              ; Exit is in 16-bit native mode.
2990 DC98              ; Data bank register is set to bank $E1 on entry and exit.
2991 DC98              ;
2992 DC98              ; Inputs:       e1_path_ptr - points to the pathname of the file
2993 DC98              ;
2994 DC98              ; Outputs:      e1_open_id   - id of next program to run  (P16 programs only)
2995 DC98              ;               e1_load_type - filetype of next program to run
2996 DC98              ;               e1_aux_type - auxtype of next program to run
2997 DC98              ;               c=0 if no error, else c=1
2998 DC98              ;               A - error code if c=1
2999 DC98              ;
3000 DC98              ; This routine will return information about a file.
3001 DC98              ;==============================================================================
3002 DC98
3003 DC98              get_info_sub PROC 
3004 DC98                       DataChk off
3005 DC98
3006 DC98                       longa on
3007 DC98                       longi on
3008 DC98
3009 DC98 2C 81 D6              bit   |e1_current_os           ; Which operating system is running?
3010 DC9B 30 03                 bmi   Get_Info_8               ; It's ProDOS 8
3011 DC9D 4C A9 DD              jmp   Get_Info_16              ; It's GS/OS
3012 DCA0
3013 DCA0
3014 DCA0              ********************************************************************************
3015 DCA0              *               Current operating system is ProDOS 8
3016 DCA0              ********************************************************************************
3017 DCA0
3018 DCA0              Get_Info_8  
3019 DCA0                       Import e1_fst_id
3020 DCA0
3021 DCA0              ; Go to 8-bit mode
3022 DCA0
3023 DCA0 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
3024 DCA2                       longa off
3025 DCA2                       longi off
3026 DCA2
3027 DCA2              ; Save current data bank register and switch DBR to bank $00
3028 DCA2
3029 DCA2 8B                    phb   
3030 DCA3 F4 00 00              pea   $0000
3031 DCA6 AB                    plb   
3032 DCA7 AB                    plb   
3033 DCA8
3034 DCA8              ; Save off enough space in bank $00 for the data structure and a pathname buffer
3035 DCA8
3036 DCA8 A2 6B                 ldx   #65+Get_Data_Size        ;size of data structure + 65 bytes
3037 DCAA BD FF 01     save_loop lda   |Bank0-1,X              ;for pathname buffer
3038 DCAD
3039 DCAD 9F 6E D8 E1           sta   >e1_Bank0_Save-1,X
3040 DCB1 CA                    dex   
3041 DCB2 D0 F6                 bne   save_loop
3042 DCB4
3043 DCB4              ; Now copy the data structure into bank $00
3044 DCB4
3045 DCB4 A2 2A                 ldx   #Get_Data_Size           ;size of data structure
3046 DCB6 BF 7E DD E0  copy_loop lda   >Get_Data-1,X
3047 DCBA 9D FF 01              sta   |Bank0-1,X
3048 DCBD CA                    dex   
3049 DCBE D0 F6                 bne   copy_loop
3050 DCC0
3051 DCC0              ; Now move pathname into bank $00 for P8 calls
3052 DCC0
3053 DCC0 C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
3054 DCC2                       longa on
3055 DCC2                       longi on
3056 DCC2
3057 DCC2 0B                    phd                            ;save current direct register
3058 DCC3 AF 71 D6 E1           lda   >e1_path_ptr+2           ;push ptr to pathname on stack
3059 DCC7 48                    pha   
3060 DCC8 AF 6F D6 E1           lda   >e1_path_ptr
3061 DCCC 48                    pha   
3062 DCCD 3B                    tsc   
3063 DCCE 5B                    tcd                            ;set direct register to point to stack
3064 DCCF
3065 DCCF E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
3066 DCD1                       longa off
3067 DCD1                       longi off
3068 DCD1
3069 DCD1 A7 01                 lda   [<1]                     ;get length byte of pathname
3070 DCD3 A8                    tay   
3071 DCD4 B7 01        move_loop lda   [<1],y
3072 DCD6 99 2A 02              sta   |P8_pathname,y           ;move pathname into bank $00
3073 DCD9 88                    dey   
3074 DCDA 10 F8                 bpl   move_loop
3075 DCDC
3076 DCDC 68                    pla                            ;clean up stack
3077 DCDD 68                    pla   
3078 DCDE 68                    pla   
3079 DCDF 68                    pla   
3080 DCE0 2B                    pld                            ;restore direct register
3081 DCE1
3082 DCE1              ; Make a ProDOS 8 GetFileInfo call
3083 DCE1
3084 DCE1 A9 C4                 lda   #p8_gfi_num
3085 DCE3 8D 24 02              sta   |P8_Call+5
3086 DCE6 A9 00                 lda   #<Get_Info_Parm
3087 DCE8 8D 25 02              sta   |P8_Call+6
3088 DCEB A9 02                 lda   #Get_Info_Parm/$100
3089 DCED 8D 26 02              sta   |P8_Call+7
3090 DCF0
3091 DCF0 20 6C DD              jsr   make_the_call
3092 DCF3 B0 5B                 bcs   p8_return
3093 DCF5
3094 DCF5              ; Check the application's filetype
3095 DCF5
3096 DCF5 AD 04 02              lda   |Get_Info_Parm+4         ; Get the application's file type.
3097 DCF8 20 0D DE              jsr   check_type               ; Make sure its a system program.
3098 DCFB B0 53                 bcs   p8_return
3099 DCFD
3100 DCFD C9 FF                 cmp   #sys_ftype               ; Is it a P8 application?
3101 DCFF F0 03                 beq   p8_app                   ; yes
3102 DD01 18                    clc                            ; no - so indicate no error
3103 DD02 80 4C                 bra   p8_return
3104 DD04
3105 DD04              ; It's a P8 application so we need to check the file size to make sure it will
3106 DD04              ; fit in bank $00 between $2000 and $beff.
3107 DD04
3108 DD04              p8_app    
3109 DD04
3110 DD04              ; Make a ProDOS 8 Open call
3111 DD04
3112 DD04 A9 C8                 lda   #p8_open_num
3113 DD06 8D 24 02              sta   |P8_Call+5
3114 DD09 A9 12                 lda   #<Open_Parm
3115 DD0B 8D 25 02              sta   |P8_Call+6
3116 DD0E A9 02                 lda   #Open_Parm/$100
3117 DD10 8D 26 02              sta   |P8_Call+7
3118 DD13
3119 DD13 20 6C DD              jsr   make_the_call
3120 DD16 B0 38                 bcs   p8_return
3121 DD18
3122 DD18              ; Make a ProDOS 8 GetEOF call
3123 DD18
3124 DD18 A9 D1                 lda   #p8_eof_num
3125 DD1A 8D 24 02              sta   |P8_Call+5
3126 DD1D A9 18                 lda   #<Get_EOF_Parm
3127 DD1F 8D 25 02              sta   |P8_Call+6
3128 DD22 A9 02                 lda   #Get_EOF_Parm/$100
3129 DD24 8D 26 02              sta   |P8_Call+7
3130 DD27
3131 DD27 20 6C DD              jsr   make_the_call
3132 DD2A B0 24                 bcs   p8_return
3133 DD2C
3134 DD2C              ; Make a ProDOS 8 Close call
3135 DD2C
3136 DD2C A9 CC                 lda   #p8_close_num
3137 DD2E 8D 24 02              sta   |P8_Call+5
3138 DD31 A9 1D                 lda   #<Close_Parm
3139 DD33 8D 25 02              sta   |P8_Call+6
3140 DD36 A9 02                 lda   #Close_Parm/$100
3141 DD38 8D 26 02              sta   |P8_Call+7
3142 DD3B
3143 DD3B 20 6C DD              jsr   make_the_call
3144 DD3E B0 10                 bcs   p8_return
3145 DD40
3146 DD40              ; Now check the file size.
3147 DD40
3148 DD40 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
3149 DD42                       longa on
3150 DD42                       longi on
3151 DD42
3152 DD42 A2 02 00              ldx   #2
3153 DD45 BD 18 02              lda   |Get_EOF_Parm,X
3154 DD48 C9 00 9F              cmp   #$9F00                   ;is the file too big?
3155 DD4B 90 03                 bcc   p8_return                ;no
3156 DD4D A9 54 00              lda   #out_of_mem              ;yes - so indicate error
3157 DD50
3158 DD50              ; Restore bank $00 space and return
3159 DD50
3160 DD50              p8_return  
3161 DD50 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
3162 DD52                       longa off
3163 DD52                       longi off
3164 DD52
3165 DD52 48                    pha                            ;save error code if any
3166 DD53 08                    php                            ;save carry info
3167 DD54
3168 DD54 A9 01                 lda   #proDOSFSID              ;assume ProDOS FST ID
3169 DD56 8F FD D5 E1           sta   >e1_fst_id               ;(has to be for P8 calls)
3170 DD5A
3171 DD5A A2 6B                 ldx   #65+Get_Data_Size
3172 DD5C BF 6E D8 E1  restore_loop lda   >e1_Bank0_Save-1,X
3173 DD60 9D FF 01              sta   |Bank0-1,X
3174 DD63 CA                    dex   
3175 DD64 D0 F6                 bne   restore_loop
3176 DD66
3177 DD66 28                    plp                            ;restore carry info
3178 DD67 68                    pla                            ;restore error code
3179 DD68 AB                    plb                            ;restore DBR
3180 DD69 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
3181 DD6B 60                    rts                            ;c=0 if no error, else c=1
3182 DD6C
3183 DD6C
3184 DD6C              ;-------------------------------------------------------------------------------
3185 DD6C
3186 DD6C              make_the_call  
3187 DD6C 22 1F 02 00           jsl   p8_call
3188 DD70 F0 0B                 beq   call_ok
3189 DD72
3190 DD72 C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
3191 DD74 22 00 D2 E1           jsl   p8_mount_vol
3192 DD78 E2 30                 sep   #$30                     ;***** return to 8-bit mode *****
3193 DD7A
3194 DD7A 90 F0                 bcc   make_the_call            ;mount window put up - return pressed
3195 DD7C 60                    rts                            ;esc pressed or window not put up
3196 DD7D
3197 DD7D              call_ok   
3198 DD7D 18                    clc   
3199 DD7E 60                    rts   
3200 DD7F
3201 DD7F              ;-------------------------------------------------------------------------------
3202 DD7F
3203 DD7F              ; get_data structure
3204 DD7F
3205 DD7F              get_data                                ; This data structure must be moved
3206 DD7F                                                      ; to bank $00 in order to call ProDOS 8.
3207 DD7F 0A                    DC B:$0A                       ; (Get_Info Parmameters)
3208 DD80 2A 02                 DC W:P8_Pathname               ;      |
3209 DD82 00 00 00 00           DS B:15                        ;      |
3210 DD91 03                    DC B:$03                       ; (Open Parameters)
3211 DD92 2A 02                 DC W:P8_Pathname               ;      |
3212 DD94 00 20                 DC W:IO_Buf                    ;      |
3213 DD96 00                    DS B:1                         ;      |
3214 DD97 02 01                 DC B:$02,$01                   ; (Get_EOF Parameters)
3215 DD99 00 00 00              DS B:3                         ;      |
3216 DD9C 01 00                 DC B:$01,$00                   ; (Close Parameters)
3217 DD9E 38                    DC B:$38                       ;SEC (P8_Call)
3218 DD9F FB                    DC B:$FB                       ;XCE   |
3219 DDA0 20 00 BF              DC B:$20,$00,$BF               ;JSR $BF00
3220 DDA3 00                    DC B:$00                       ;      |
3221 DDA4 00 00                 DC B:$00,$00                   ;      |
3222 DDA6 18                    DC B:$18                       ;CLC   |
3223 DDA7 FB                    DC B:$FB                       ;XCE   |
3224 DDA8 6B                    DC B:$6B                       ;RTL   |
3225 DDA9              get_data_size equ   *-get_data          ;  <---'
3226 DDA9
3227 DDA9                       EXPORT bank0_area_used:equ
3228 DDA9              bank0_area_used equ get_data_size+65 
3229 DDA9
3230 DDA9              ; location equates
3231 DDA9
3232 DDA9              io_buf   equ   $002000                  ; for our I/O buffer
3233 DDA9              bank0    equ   $000200                  ; for our ProDOS 8 call area
3234 DDA9
3235 DDA9              ; Offsets into get_data structure
3236 DDA9
3237 DDA9              get_info_parm equ   bank0
3238 DDA9              open_parm equ   get_info_parm+18
3239 DDA9              get_eof_parm equ   open_parm+6
3240 DDA9              close_parm equ   get_eof_parm+5
3241 DDA9              p8_call  equ   close_parm+2
3242 DDA9
3243 DDA9              p8_pathname equ   bank0+get_data_size
3244 DDA9
3245 DDA9
3246 DDA9
3247 DDA9              ********************************************************************************
3248 DDA9              *               Current operating system is GS/OS
3249 DDA9              ********************************************************************************
3250 DDA9
3251 DDA9              Get_Info_16  
3252 DDA9                       longa on
3253 DDA9                       longi on
3254 DDA9
3255 DDA9              ; First check to see if the program we want to launch has been previously run.
3256 DDA9              ; If so, then we know it's a P16 file.
3257 DDA9              ; NOTE - the reason this call is made instead of just doing the GetFileInfo call
3258 DDA9              ; is because GetFileInfo will spin the disk. So, if the ID exists, we save time.
3259 DDA9
3260 DDA9 48                    pha                            ; Push space for output user ID.
3261 DDAA AD 71 D6              lda   |e1_path_ptr+2           ; Push pointer to the pathname and
3262 DDAD 8D D5 D5              sta   |e1_gfi_ptr+2            ; also store in e1_gfi_parms1 for later
3263 DDB0 48                    pha   
3264 DDB1 AD 6F D6              lda   |e1_path_ptr
3265 DDB4 8D D3 D5              sta   |e1_gfi_ptr
3266 DDB7 48                    pha   
3267 DDB8 A2 11 21 22           _getuserid2 
3268 DDBF 68                    pla                            ; Pull off output user ID.
3269 DDC0 B0 13                 bcs   no_id                    ; No ID
3270 DDC2 A9 B3 00              lda   #s16_ftype               ; Set load type to a P16 system file type.
3271 DDC5 8D 83 D6              sta   |e1_load_type
3272 DDC8 60                    rts                            ; return with carry clear
3273 DDC9
3274 DDC9              ; This entry point is used to force a GetFileInfo call on the file specified by e1_path_ptr.
3275 DDC9              ; It's used to get the auxtype of a file that the loader knows about, but which GS/OS doesn't.
3276 DDC9              ; By checking the auxtype, we can determine whether or not to leave the SHR screen enabled.
3277 DDC9
3278 DDC9                       entry force_get_info
3279 DDC9              force_get_info  
3280 DDC9 AD 71 D6              lda   |e1_path_ptr+2           ; set up pathname pointer in parameter block
3281 DDCC 8D D5 D5              sta   |e1_gfi_ptr+2
3282 DDCF AD 6F D6              lda   |e1_path_ptr
3283 DDD2 8D D3 D5              sta   |e1_gfi_ptr
3284 DDD5              ;fall into the following section
3285 DDD5
3286 DDD5              ; The application has not been previously run, so now make a GetFileInfo call to
3287 DDD5              ; determine the file type and to detect any possible errors that may occur if
3288 DDD5              ; we try to load and execute the file.
3289 DDD5
3290 DDD5              no_id     
3291 DDD5 22 A8 00 E1           _GetFileInfo1 e1_gfi_parms1 
3292 DDDF 90 05                 bcc   @no_err
3293 DDE1 C9 4F 00              cmp   #buff_too_small          ; option list buffer too small?
3294 DDE4 D0 23                 bne   ret_cs                   ; no, must be a real error
3295 DDE6              @no_err   
3296 DDE6 AD DB D5              lda   |e1_gfi_atype            ; Get the auxtype of the file
3297 DDE9 8D 85 D6              sta   |e1_aux_type             ; and save for later
3298 DDEC
3299 DDEC AD D9 D5              lda   |e1_gfi_ftype            ; Get the filetype of the file
3300 DDEF 20 0D DE              jsr   check_type               ; Make sure it's a system file type
3301 DDF2 B0 15                 bcs   ret_cs
3302 DDF4 C9 FF 00              cmp   #sys_ftype               ; is it a P8 application?
3303 DDF7 D0 12                 bne   ret_cc                   ; no
3304 DDF9
3305 DDF9              ; It's a ProDOS 8 application, so check the file size to be
3306 DDF9              ; sure it will fit in bank $00 between $2000 and $BEFF.
3307 DDF9
3308 DDF9 AD F7 D5              lda   |e1_gfi_eof+2            ; get hi word of the eof
3309 DDFC D0 08                 bne   too_big
3310 DDFE AD F5 D5              lda   |e1_gfi_eof              ; get lo word of the eof
3311 DE01 C9 00 9F              cmp   #$9F00
3312 DE04 90 05                 bcc   ret_cc
3313 DE06 A9 54 00     too_big  lda   #out_of_mem              ; yes - so indicate error
3314 DE09 38           ret_cs   sec                            ; indicate error
3315 DE0A 60                    rts   
3316 DE0B
3317 DE0B 18           ret_cc   clc                            ; indicate no error
3318 DE0C 60                    rts   
3319 DE0D
3320 DE0D
3321 DE0D
3322 DE0D              ;-------------------------------------------------------------------------------
3323 DE0D              ; check_type
3324 DE0D              ;
3325 DE0D              ; Entry is in 8-bit or 16-bit native mode.
3326 DE0D              ; Exit is in same mode as entry.
3327 DE0D              ; Data bank register is unknown at entry.
3328 DE0D              ;
3329 DE0D              ; Checks file type to see if it's type $b3, $b5, or $ff. If not, reports an
3330 DE0D              ; error.
3331 DE0D              ;
3332 DE0D              ; Inputs:       A = file type to check
3333 DE0D              ;
3334 DE0D              ; Outputs:      A = input file type if no error, else error code
3335 DE0D              ;               e1_load_type = set to input value of A
3336 DE0D              ;               c=0 if no error, else c=1
3337 DE0D              ;-------------------------------------------------------------------------------
3338 DE0D
3339 DE0D              check_type  
3340 DE0D
3341 DE0D 08                    php                            ; Save processor status.
3342 DE0E
3343 DE0E C2 30                 rep   #$30                     ;***** begin 16-bit mode *****
3344 DE10                       longa on
3345 DE10                       longi on
3346 DE10
3347 DE10 29 FF 00              and   #$00ff                   ; Strip off hi byte of passed type.
3348 DE13 8F 83 D6 E1           sta   >e1_load_type
3349 DE17 C9 B3 00              cmp   #s16_ftype               ; Is it a ProDOS 16 system file?
3350 DE1A F0 10                 beq   type_ok                  ; yes
3351 DE1C C9 B5 00              cmp   #shell_ftype             ; Is it a ProDOS 16 shell file?
3352 DE1F F0 0B                 beq   type_ok                  ; yes
3353 DE21 C9 FF 00              cmp   #sys_ftype               ; Is it a ProDOS 8 system file?
3354 DE24 F0 06                 beq   type_ok                  ; yes
3355 DE26 A9 5C 00              lda   #not_system_file         ; None of the above so report error
3356 DE29 28                    plp                            ; Restore mode
3357 DE2A 38                    sec                            ; indicate error
3358 DE2B 60                    rts   
3359 DE2C
3360 DE2C              type_ok   
3361 DE2C 28                    plp                            ; Restore mode
3362 DE2D 18                    clc                            ; indicate no error
3363 DE2E 60                    rts   
3364 DE2F
3365 DE2F                       DataChk on
3366 DE2F                       ENDP 
3367 DE2F
3368 DE2F
3369 DE2F
3370 DE2F                       eject 
3371 DE2F              ;===============================================================================
3372 DE2F              ; alloc_gsos_mem
3373 DE2F              ;
3374 DE2F              ; Entry is in 16-bit native mode.
3375 DE2F              ; Exit is in 16-bit native mode.
3376 DE2F              ; Data bank register is preserved.
3377 DE2F              ;
3378 DE2F              ; Inputs:       none
3379 DE2F              ;
3380 DE2F              ; Outputs:      c - 0 if no error, 1 if error
3381 DE2F              ;               A - error code if c=1
3382 DE2F              ;
3383 DE2F              ; Notes:        Must return with an RTL since called from GLDR and E0 code.
3384 DE2F              ;
3385 DE2F              ; This routine loops through the e1_gsos_segs2 table and uses the information to
3386 DE2F              ; allocate the reserved memory segments for GS/OS and the System Loader.
3387 DE2F              ; The segments are allocated with a $32xx segment ID.
3388 DE2F              ;===============================================================================
3389 DE2F
3390 DE2F              alloc_gsos_mem  PROC 
3391 DE2F                       DataChk off
3392 DE2F
3393 DE2F                       longa on
3394 DE2F                       longi on
3395 DE2F
3396 DE2F 8B                    phb                            ;save data bank register
3397 DE30 F4 E1 E1              pea   $e1e1
3398 DE33 AB                    plb                            ;set data bank register to bank $e1
3399 DE34 AB                    plb   
3400 DE35
3401 DE35 A2 00 00              ldx   #0                       ;init table index
3402 DE38              loop      
3403 DE38 8E 53 D6              stx   |e1_word_temp            ;save table index
3404 DE3B
3405 DE3B BC 67 D5              ldy   |e1_gsos_segs2+4,x       ;hi word of seg location
3406 DE3E BD 65 D5              lda   |e1_gsos_segs2+2,x       ;lo word of seg location
3407 DE41 48                    pha   
3408 DE42 BD 69 D5              lda   |e1_gsos_segs2+6,x       ;seg size
3409 DE45 FA                    plx   
3410 DE46
3411 DE46 20 90 DE              jsr   alloc_os_mem             ;allocate the segment
3412 DE49 B0 0C                 bcs   done
3413 DE4B
3414 DE4B AD 53 D6              lda   |e1_word_temp            ;retrieve table index
3415 DE4E 69 0C 00              adc   #12
3416 DE51 AA                    tax                            ;adjust index to point to next table entry
3417 DE52
3418 DE52 BD 63 D5              lda   |e1_gsos_segs2,x         ;at end of table?
3419 DE55 10 E1                 bpl   loop                     ;no
3420 DE57
3421 DE57 AB           done     plb                            ;restore data bank register
3422 DE58 6B                    rtl   
3423 DE59
3424 DE59                       DataChk on
3425 DE59                       ENDP 
3426 DE59
3427 DE59
3428 DE59
3429 DE59                       eject 
3430 DE59              ;===============================================================================
3431 DE59              ; alloc_p8_mem
3432 DE59              ;
3433 DE59              ; Entry is in 16-bit native mode.
3434 DE59              ; Exit is in 16-bit native mode.
3435 DE59              ; Data bank register is set to bank $E1 on entry and exit.
3436 DE59              ;
3437 DE59              ; Inputs:       none
3438 DE59              ;
3439 DE59              ; Outputs:      c - 0 if no error, 1 if error
3440 DE59              ;               A - error code if c=1
3441 DE59              ;
3442 DE59              ; Allocate all necessary memory for the Apple //e program environment.
3443 DE59              ; The segments are allocated with a $32xx segment ID.
3444 DE59              ;
3445 DE59              ; Specifically the memory allocated is:
3446 DE59              ;
3447 DE59              ; Bank $00 : $0800-$bfff ; All //e memory allocatable via memory manager.
3448 DE59              ; Bank $01 : $0800-$bfff ; All //e memory allocatable via memory manager.
3449 DE59              ; Bank $e0 : $2000-$5fff ; Hi-res pgs 1 & 2.
3450 DE59              ; Bank $e1 : $2000-$9fff ; Hi-res pgs 1 & 2, Super Hi-res.
3451 DE59              ;===============================================================================
3452 DE59
3453 DE59              alloc_p8_mem  PROC 
3454 DE59
3455 DE59                       longa on
3456 DE59                       longi on
3457 DE59
3458 DE59 A9 00 B8              lda   #$b800                   ; From $0800-$0BFFF
3459 DE5C A2 00 08              ldx   #$0800                   ; Starting at $800
3460 DE5F A0 00 00              ldy   #$0000                   ; Bank $00
3461 DE62 20 90 DE              jsr   alloc_os_mem
3462 DE65 B0 28                 bcs   done                     ; Branch if error.
3463 DE67
3464 DE67 A9 00 B8              lda   #$b800                   ; From $0800-$0BFFF
3465 DE6A A2 00 08              ldx   #$0800                   ; Starting at $800.
3466 DE6D A0 01 00              ldy   #$0001                   ; Bank $01.
3467 DE70 20 90 DE              jsr   alloc_os_mem
3468 DE73 B0 1A                 bcs   done                     ; Branch if error.
3469 DE75
3470 DE75 A9 00 40              lda   #$4000                   ; From $2000-$5FFF
3471 DE78 A2 00 20              ldx   #$2000                   ; Starting at $2000
3472 DE7B A0 E0 00              ldy   #$00e0                   ; Bank $E0.
3473 DE7E 20 90 DE              jsr   alloc_os_mem
3474 DE81 B0 0C                 bcs   done                     ; Branch if error.
3475 DE83
3476 DE83 A9 00 80              lda   #$8000                   ; From $2000-$9FFF
3477 DE86 A2 00 20              ldx   #$2000                   ; Starting at $2000
3478 DE89 A0 E1 00              ldy   #$00e1                   ; Bank $E1.
3479 DE8C 20 90 DE              jsr   alloc_os_mem
3480 DE8F 60           done     rts                            ; Carry set if error, clear if no error.
3481 DE90
3482 DE90                       ENDP 
3483 DE90
3484 DE90
3485 DE90
3486 DE90                       eject 
3487 DE90              ;===============================================================================
3488 DE90              ; alloc_os_mem
3489 DE90              ;
3490 DE90              ; Entry is in 16-bit native mode.
3491 DE90              ; Exit is in 16-bit native mode.
3492 DE90              ; Data bank register is unknown.
3493 DE90              ;
3494 DE90              ; Inputs:       A - # of bytes to allocate.
3495 DE90              ;               X - Lo word of start address of segment.
3496 DE90              ;               Y - Hi word of start address of segment.
3497 DE90              ;               e1_os_mem_id - contains the ID used by GLDR and GQuit when
3498 DE90              ;                              allocating reserved memory segments for GS/OS and P8.
3499 DE90              ;
3500 DE90              ; Outputs:      c - 0 if no error; 1 if error.
3501 DE90              ;               A - error code if c=1
3502 DE90              ;               X - Low word of handle to allocated segment.
3503 DE90              ;               Y - High word of handle.
3504 DE90              ;
3505 DE90              ; This routine is used to allocate reserved memory segments for GS/OS and P8.
3506 DE90              ; The segments are allocated with the attributes - locked, fixed, not purgable,
3507 DE90              ;   can't cross bank boundary, may use special memory, fixed address, fixed bank.
3508 DE90              ; The segments are allocated with a $32xx segment ID.
3509 DE90              ; This routine only allows a 2 byte segment size.
3510 DE90              ;===============================================================================
3511 DE90
3512 DE90              alloc_os_mem PROC 
3513 DE90
3514 DE90                       longa on
3515 DE90                       longi on
3516 DE90
3517 DE90 48                    pha                            ; Reserve space for Handle result.
3518 DE91 48                    pha   
3519 DE92 F4 00 00              pea   0                        ; Hi word of seg size.
3520 DE95 48                    pha                            ; Low word of seg size (input).
3521 DE96 AF 55 D6 E1           lda   >e1_os_mem_id            ; segment id
3522 DE9A 48                    pha   
3523 DE9B F4 13 C0              pea   mm_attrib                ; Seg attributes word.
3524 DE9E 5A                    phy                            ; Hi  word of seg location (input)
3525 DE9F DA                    phx                            ; Low word of seg location (input)
3526 DEA0 A2 02 09 22           _newhandle 
3527 DEA7 FA                    plx                            ; Pull Handle to the memory segment,
3528 DEA8 7A                    ply                            ; saving it in X and Y.
3529 DEA9 60                    rts   
3530 DEAA
3531 DEAA                       ENDP 
3532 DEAA
3533 DEAA
3534 DEAA
3535 DEAA                       eject 
3536 DEAA              ;===============================================================================
3537 DEAA              ; alloc_storage
3538 DEAA              ;
3539 DEAA              ; Entry is in 16-bit native mode.
3540 DEAA              ; Exit is in 16-bit native mode.
3541 DEAA              ; Data bank register is set to bank $E1 on entry and exit.
3542 DEAA              ;
3543 DEAA              ; Inputs:       e1_storage_id - contains the ID used by GQuit when
3544 DEAA              ;                               allocating storage space for GS/OS.
3545 DEAA              ;
3546 DEAA              ; Outputs:      c - 0 if no error, 1 if error
3547 DEAA              ;               A - error code if c=1
3548 DEAA              ;
3549 DEAA              ; Allocate segments to store GS/OS in while ProDOS 8 is running.
3550 DEAA              ; The segments are allocated with a $32xx segment ID.
3551 DEAA              ;===============================================================================
3552 DEAA
3553 DEAA              alloc_storage  PROC 
3554 DEAA                       DataChk off
3555 DEAA
3556 DEAA                       longa on
3557 DEAA                       longi on
3558 DEAA
3559 DEAA A2 00 00              ldx   #0
3560 DEAD              loop      
3561 DEAD BD 33 D5              lda   |e1_gsos_segs,x
3562 DEB0 30 35                 bmi   done
3563 DEB2
3564 DEB2 48                    pha                            ; space for handle result
3565 DEB3 48                    pha   
3566 DEB4 F4 00 00              pea   0                        ; hi word of seg size
3567 DEB7 BD 39 D5              lda   |e1_gsos_segs+6,x        ; lo word of seg size
3568 DEBA 48                    pha   
3569 DEBB AD 57 D6              lda   |e1_storage_id
3570 DEBE 48                    pha   
3571 DEBF F4 08 00              pea   storage_attrib           ; seg attributes word
3572 DEC2 A9 00 00              lda   #0
3573 DEC5 48                    pha                            ; hi word of seg location
3574 DEC6 48                    pha                            ; lo word of seg location
3575 DEC7 8E 53 D6              stx   |e1_word_temp
3576 DECA A2 02 09 22           _newhandle 
3577 DED1 B0 12                 bcs   error
3578 DED3 AE 53 D6              ldx   |e1_word_temp
3579 DED6 68                    pla                            ; pull handle to the memory segment
3580 DED7 9D 3B D5              sta   |e1_gsos_segs+8,x        ; and save
3581 DEDA 68                    pla   
3582 DEDB 9D 3D D5              sta   |e1_gsos_segs+10,x
3583 DEDE 8A                    txa   
3584 DEDF 69 0C 00              adc   #12
3585 DEE2 AA                    tax   
3586 DEE3 80 C8                 bra   loop
3587 DEE5
3588 DEE5 FA           error    plx                            ;clean up stack
3589 DEE6 FA                    plx   
3590 DEE7 60           done     rts   
3591 DEE8
3592 DEE8                       DataChk off
3593 DEE8                       ENDP 
3594 DEE8
3595 DEE8
3596 DEE8
3597 DEE8                       eject 
3598 DEE8              ;===============================================================================
3599 DEE8              ; alloc_user_zp
3600 DEE8              ;
3601 DEE8              ; Entry is in 16-bit native mode.
3602 DEE8              ; Exit is in 16-bit native mode.
3603 DEE8              ; Data bank register is preserved.
3604 DEE8              ; Direct register is set to the user's zero page on exit.
3605 DEE8              ;
3606 DEE8              ; Inputs:       e1_zp_start - start address of user's zero page; 0 if none allocated
3607 DEE8              ;               e1_zp_size - size of user's zero page; 0 if none allocated
3608 DEE8              ;
3609 DEE8              ; Outputs:      c - 0 if no error ; 1 if error.
3610 DEE8              ;               A - starting address of user's stack if c=0; else error code if c=1
3611 DEE8              ;               e1_zp_start - start address of user's zero page
3612 DEE8              ;               e1_zp_size - size of user's zero page
3613 DEE8              ;               e1_zp_handle - handle to user's zero page; 0 if allocated by loader
3614 DEE8              ;
3615 DEE8              ; Notes:        This routine alters the direct page register.
3616 DEE8              ;               Must return with an RTL since called from GLDR and E0 code.
3617 DEE8              ;
3618 DEE8              ; This routine sets up the user's Direct register and sets A to the start
3619 DEE8              ; of the user's stack.  If the loader has allocated the user's zero page
3620 DEE8              ; segment, then this routine uses the values returned by the loader.  Otherwise,
3621 DEE8              ; it will allocate a zero page segment with the following attributes:
3622 DEE8              ; locked, fixed memory, purge level of 1, no bank crossing, may use special
3623 DEE8              ; memory, page aligned, not fixed address, fixed bank.
3624 DEE8              ; The segment size will be 4K.
3625 DEE8              ;===============================================================================
3626 DEE8
3627 DEE8              alloc_user_zp PROC 
3628 DEE8                       DataChk off
3629 DEE8
3630 DEE8                       longa on
3631 DEE8                       longi on
3632 DEE8
3633 DEE8 8B                    phb                            ; save data bank register
3634 DEE9 F4 E1 E1              pea   $e1e1                    ; set data bank register to bank $E1
3635 DEEC AB                    plb   
3636 DEED AB                    plb   
3637 DEEE
3638 DEEE              ;determine if loader allocated user's zero page
3639 DEEE
3640 DEEE AD 9B D6              lda   |e1_zp_start             ; did loader allocate user's zero page?
3641 DEF1 D0 33                 bne   set_d_reg                ; yes
3642 DEF3
3643 DEF3              ;allocate a zero page segment for user
3644 DEF3
3645 DEF3 48                    pha                            ; Reserve space for Handle result.
3646 DEF4 48                    pha   
3647 DEF5 A2 00 00              ldx   #$0000
3648 DEF8 DA                    phx                            ; Hi word of seg size. ($0000)
3649 DEF9 A9 00 10              lda   #zp_size                 ; Default zero page size
3650 DEFC 48                    pha   
3651 DEFD 8D 9D D6              sta   |e1_zp_size              ; Save zero page size for later
3652 DF00 AD 77 D6              lda   |e1_user_id              ; Use user's ID for his zero page segment
3653 DF03 48                    pha   
3654 DF04 F4 15 C1              pea   zp_attrib                ; Seg attributes word.
3655 DF07 DA                    phx                            ; Address of segment to be
3656 DF08 DA                    phx                            ; somewhere in bank 0. (X still 0)
3657 DF09 A2 02 09 22           _newhandle 
3658 DF10 A8                    tay                            ; save error code
3659 DF11 3B                    tsc                            ; move our direct page to stack so we
3660 DF12 5B                    tcd                            ; can dereference the handle
3661 DF13 A7 01                 lda   [<1]                     ; get address of user's zero page - only lo
3662 DF15 8D 9B D6              sta   |e1_zp_start             ; word since it's a bank 0 address.
3663 DF18 68                    pla                            ; pull Handle to the memory segment
3664 DF19 8D 97 D6              sta   |e1_zp_handle            ; and save
3665 DF1C 68                    pla   
3666 DF1D 8D 99 D6              sta   |e1_zp_handle+2
3667 DF20 98                    tya                            ; Restore error code.
3668 DF21 B0 09                 bcs   exit
3669 DF23
3670 DF23 AD 9B D6              lda   |e1_zp_start             ; retrieve start address of user's zero page
3671 DF26
3672 DF26              ;set D register to user's zero page
3673 DF26              ;set A register to user's stack
3674 DF26
3675 DF26 5B           set_d_reg tcd                           ; set Direct register
3676 DF27 18                    clc                            ; then add zero page size to set stack
3677 DF28 6D 9D D6              adc   |e1_zp_size              ; A now equals user's S + 1.
3678 DF2B 3A                    dec   a                        ; Adjust for proper S value.
3679 DF2C
3680 DF2C AB           exit     plb                            ; restore data bank register
3681 DF2D 6B                    rtl   
3682 DF2E
3683 DF2E                       DataChk on
3684 DF2E                       ENDP 
3685 DF2E
3686 DF2E
3687 DF2E
3688 DF2E                       eject 
3689 DF2E              ;===============================================================================
3690 DF2E              ; id_routines
3691 DF2E              ;
3692 DF2E              ; Entry is in 16-bit native mode.
3693 DF2E              ; Exit is in 16-bit native mode.
3694 DF2E              ; Data bank register is set to bank $E1 on entry and exit.
3695 DF2E              ;
3696 DF2E              ; Each entry in the id_stack consists of 4 bytes.  They are used as follows -
3697 DF2E              ;   Byte 0 is the lo byte of the current id
3698 DF2E              ;   Byte 1 is the hi byte of the current id
3699 DF2E              ;   Byte 2 is the lo byte of the quit flag
3700 DF2E              ;   Byte 3 is the hi byte of the quit flag
3701 DF2E              ;===============================================================================
3702 DF2E
3703 DF2E              id_routines PROC 
3704 DF2E                       DataChk off
3705 DF2E
3706 DF2E                       longa on
3707 DF2E                       longi on
3708 DF2E
3709 DF2E              ;-------------------------------------------------------------------------------
3710 DF2E              ; push_id
3711 DF2E              ;
3712 DF2E              ; Inputs:       none
3713 DF2E              ;
3714 DF2E              ; Outputs:      c - 1 if stack full, else 0
3715 DF2E              ;               A - error code if c=1
3716 DF2E              ;-------------------------------------------------------------------------------
3717 DF2E
3718 DF2E                       EXPORT push_id
3719 DF2E              push_id   
3720 DF2E AE 9F D6              ldx   |e1_id_stack_index       ;get index to id_stack
3721 DF31 E0 40 00              cpx   #id_stack_size           ;are we at the end?
3722 DF34 B0 1A                 bcs   push_id0                 ;yes
3723 DF36 AF 29 C0 00           lda   >newvideo                ;get current screen state
3724 DF3A 29 80 00              and   #%10000000               ;only need SHR status
3725 DF3D EB                    xba                            ;put into high byte of accumulator
3726 DF3E 0D 79 D6              ora   |e1_current_id           ;combine with current id
3727 DF41 9D A1 D6              sta   |e1_id_stack,x           ;save it
3728 DF44 E8                    inx   
3729 DF45 E8                    inx   
3730 DF46 AD 7F D6              lda   |e1_quit_flags           ;get quit flags
3731 DF49 9D A1 D6              sta   |e1_id_stack,x           ;save it
3732 DF4C E8                    inx   
3733 DF4D E8                    inx   
3734 DF4E 80 1C                 bra   pnp_out
3735 DF50
3736 DF50 A9 5F 00     push_id0 lda   #stack_overflow          ;id stack full error
3737 DF53 60                    rts                            ;return with carry set
3738 DF54
3739 DF54
3740 DF54              ;-------------------------------------------------------------------------------
3741 DF54              ; pop_id
3742 DF54              ;
3743 DF54              ; Inputs:       none
3744 DF54              ;
3745 DF54              ; Outputs:      c - 1 if stack was empty, else 0
3746 DF54              ;-------------------------------------------------------------------------------
3747 DF54
3748 DF54                       EXPORT pop_id
3749 DF54              pop_id    
3750 DF54 AD 9F D6              lda   |e1_id_stack_index       ;Get index to ID Stack
3751 DF57 F0 18                 beq   empty_stack              ;ID stack is empty
3752 DF59
3753 DF59 A9 B3 00              lda   #$b3
3754 DF5C 8D 83 D6              sta   |e1_load_type            ;set the load type
3755 DF5F AE 9F D6              ldx   |e1_id_stack_index       ;get index to id stack
3756 DF62 CA                    dex   
3757 DF63 CA                    dex   
3758 DF64 CA                    dex   
3759 DF65 CA                    dex   
3760 DF66 BD A1 D6              lda   |e1_id_stack,x           ;get id
3761 DF69 8D 7B D6              sta   |e1_open_id              ;save previous id
3762 DF6C 8E 9F D6     pnp_out  stx   |e1_id_stack_index       ;update the index to id stack
3763 DF6F 18                    clc                            ;indicate no error
3764 DF70 60                    rts   
3765 DF71
3766 DF71 38           empty_stack sec                         ;indicate error
3767 DF72 60                    rts   
3768 DF73
3769 DF73
3770 DF73              ;-------------------------------------------------------------------------------
3771 DF73              ; check_id_stack
3772 DF73              ;
3773 DF73              ; Inputs:       e1_open_id - ID to check for
3774 DF73              ;
3775 DF73              ; Outputs:      c - 1 if ID on stack, else 0
3776 DF73              ;
3777 DF73              ; This routine will search the ID stack to see if the ID for the program
3778 DF73              ; we are launching is already on the stack.
3779 DF73              ;-------------------------------------------------------------------------------
3780 DF73
3781 DF73                       EXPORT check_id_stack
3782 DF73              check_id_stack  
3783 DF73 AE 9F D6              ldx   |e1_id_stack_index       ;get index to id_stack
3784 DF76
3785 DF76              check_loop  
3786 DF76 CA                    dex                            ;point to next record
3787 DF77 CA                    dex   
3788 DF78 CA                    dex   
3789 DF79 CA                    dex   
3790 DF7A 10 02                 bpl   check_it
3791 DF7C 18                    clc                            ;if done with stack, return carry clear
3792 DF7D 60                    rts   
3793 DF7E
3794 DF7E BD A1 D6     check_it lda   |e1_id_stack,x           ;get the user id
3795 DF81 0A                    asl   a                        ;clear SHR bit
3796 DF82 4A                    lsr   a
3797 DF83 CD 7B D6              cmp   |e1_open_id              ;does it match?
3798 DF86 D0 EE                 bne   check_loop               ;no
3799 DF88 38                    sec                            ;yes - so return carry set
3800 DF89 60                    rts   
3801 DF8A
3802 DF8A                       DataChk on
3803 DF8A                       ENDP 
3804 DF8A
3805 DF8A
3806 DF8A
3807 DF8A                       eject 
3808 DF8A              ;===============================================================================
3809 DF8A              ; gsos_nonfatal
3810 DF8A              ;
3811 DF8A              ; Entry is in 16-bit native mode.
3812 DF8A              ; Exit is in 16-bit native mode.
3813 DF8A              ; Data bank register is unknown.
3814 DF8A              ;
3815 DF8A              ; Inputs:       X - message #
3816 DF8A              ;
3817 DF8A              ; Outputs:      A - return value of selected button
3818 DF8A              ;
3819 DF8A              ; Notes:        This routine may not return.
3820 DF8A              ;               This routine assumes that a button return value of 0
3821 DF8A              ;               always corresponds to a "Restart" button.
3822 DF8A              ;
3823 DF8A              ; Generate a non-fatal error while running under GS/OS.
3824 DF8A              ; If the message displayed contains a "Restart" button and the user selects it,
3825 DF8A              ; this routine will call SCM to restart the system.  Otherwise, this routine will
3826 DF8A              ; return the value of the selected button.
3827 DF8A              ;===============================================================================
3828 DF8A
3829 DF8A              gsos_nonfatal PROC 
3830 DF8A                       Import shutdown_reboot
3831 DF8A                       longa on
3832 DF8A                       longi on
3833 DF8A
3834 DF8A DA                    phx                            ;message #
3835 DF8B A9 00 00              lda   #0
3836 DF8E 48                    pha                            ;ptr to substitution string 1 (unused)
3837 DF8F 48                    pha   
3838 DF90              call_scm  
3839 DF90 48                    pha                            ;ptr to substitution string 2 (unused)
3840 DF91 48                    pha   
3841 DF92 22 94 FC 01           jsl   report_error             ;put up non-fatal error message
3842 DF96 D0 04                 bne   return                   ;A=0 if 'Restart' button selected
3843 DF98 5C B3 E8 00           jmp   >shutdown_reboot         ;call SCM to restart the system
3844 DF9C
3845 DF9C 60           return   rts                            ;A = return value of selected button
3846 DF9D
3847 DF9D                       entry gsos_nonfatal2
3848 DF9D              gsos_nonfatal2  
3849 DF9D                       DataChk Off
3850 DF9D                       Import e1_errBuf,e1_errStr
3851 DF9D
3852 DF9D 48                    pha                            ;put error number on stack
3853 DF9E F4 E1 00              pea   e1_errBuf>>16            ;buffer address
3854 DFA1 F4 DB D8              pea   e1_errBuf
3855 DFA4 F4 04 00              pea   4                        ;buffer length
3856 DFA7 A2 0B 22              ldx   #$220B                   ;Int2Hex call
3857 DFAA 22 00 00 E1           jsl   $E10000
3858 DFAE
3859 DFAE F4 34 00              pea   #52                      ;message #
3860 DFB1 F4 E1 00              pea   e1_errStr>>16            ;subsititution string pointer
3861 DFB4 F4 DA D8              pea   e1_errStr
3862 DFB7 A9 00 00              lda   #0                       ;borrow remainder of code
3863 DFBA 80 D4                 bra   call_scm
3864 DFBC
3865 DFBC                       DataChk On
3866 DFBC                       ENDP 
3867 DFBC
3868 DFBC
3869 DFBC
3870 DFBC                       eject 
3871 DFBC              ;===============================================================================
3872 DFBC              ; gsos_fatal_err
3873 DFBC              ; gsos_fatal_err2
3874 DFBC              ;
3875 DFBC              ; Entry is in 16-bit native mode.
3876 DFBC              ; Data bank register is unknown.
3877 DFBC              ;
3878 DFBC              ; Inputs:       A - error code
3879 DFBC              ;               X - message # (on entry to gsos_fatal_err2)
3880 DFBC              ;
3881 DFBC              ; Outputs:      none
3882 DFBC              ;
3883 DFBC              ; Notes:        This routine does not return.
3884 DFBC              ;
3885 DFBC              ; Generate a fatal error while running under GS/OS.
3886 DFBC              ;===============================================================================
3887 DFBC
3888 DFBC              gsos_fatal_err PROC 
3889 DFBC
3890 DFBC                       longa on
3891 DFBC                       longi on
3892 DFBC
3893 DFBC A2 0F 00              ldx   #quit_err
3894 DFBF
3895 DFBF                       EXPORT gsos_fatal_err2
3896 DFBF              gsos_fatal_err2  
3897 DFBF A8                    tay                            ;save error # in Y
3898 DFC0 A9 FF BF              lda   #stack_top               ;set up correct stack
3899 DFC3 1B                    tcs   
3900 DFC4
3901 DFC4 5A                    phy                            ;error #
3902 DFC5 DA                    phx                            ;message #
3903 DFC6 A9 00 00              lda   #0
3904 DFC9 48                    pha                            ;no substitution string
3905 DFCA 48                    pha   
3906 DFCB 22 A0 FC 01           jsl   report_fatal             ;fatal error - no return
3907 DFCF
3908 DFCF                       ENDP 
3909 DFCF
3910 DFCF
3911 DFCF
3912 DFCF                       eject 
3913 DFCF              ;===============================================================================
3914 DFCF              ; p8_fatal_err
3915 DFCF              ; p8_fatal_err2
3916 DFCF              ;
3917 DFCF              ; Entry is in 16-bit native mode.
3918 DFCF              ; Data bank register is unknown.
3919 DFCF              ;
3920 DFCF              ; Inputs:       A - error code
3921 DFCF              ;
3922 DFCF              ; Outputs:      none
3923 DFCF              ;
3924 DFCF              ; Notes:        This routine does not return.
3925 DFCF              ;
3926 DFCF              ; Generate a fatal error using the System Failure Manager.
3927 DFCF              ;===============================================================================
3928 DFCF
3929 DFCF              p8_fatal_err PROC 
3930 DFCF
3931 DFCF                       longa on
3932 DFCF                       longi on
3933 DFCF
3934 DFCF              ; Mask off high byte of error code since it may be garbage.
3935 DFCF
3936 DFCF 29 FF 00              and   #$00ff
3937 DFD2
3938 DFD2              ; Push error code on stack as input to system death call.
3939 DFD2
3940 DFD2                       EXPORT p8_fatal_err2
3941 DFD2              p8_fatal_err2  
3942 DFD2 48                    pha   
3943 DFD3
3944 DFD3              ; Move our system death message out of the LC area to anywhere else before dying.
3945 DFD3
3946 DFD3                       longa off
3947 DFD3                       longi off
3948 DFD3 E2 30                 sep   #$30                     ;***** begin 8-bit mode *****
3949 DFD5
3950 DFD5 AF 27 D9 E1           lda   >e1_fatal_msg            ;get length byte
3951 DFD9 AA                    tax   
3952 DFDA
3953 DFDA BF 27 D9 E1  fatal_loop lda   >e1_fatal_msg,x
3954 DFDE 9F 00 20 00           sta   >$002000,x
3955 DFE2 CA                    dex   
3956 DFE3 10 F5                 bpl   fatal_loop
3957 DFE5
3958 DFE5                       longa on
3959 DFE5                       longi on
3960 DFE5 C2 30                 rep   #$30                     ;***** return to 16-bit mode *****
3961 DFE7
3962 DFE7              ; Call the system death manager - doesn't return
3963 DFE7
3964 DFE7 F4 00 00              pea   $0000                    ; Message pointer hi-word
3965 DFEA F4 00 20              pea   $2000                    ; Message pointer lo-word
3966 DFED A2 03 15 22           _sysfailmgr 
3967 DFF4
3968 DFF4                       ENDP 
3969 DFF4
3970 DFF4
3971 DFF4
3972 DFF4                       EXPORT e0_end
3973 DFF4              e0_end   PROC 
3974 DFF4                       ENDP 
